#ifndef LLL__H
#define LLL__H

#include "mat_ZZ.h"


long LLL(ZZ& det, matrix(ZZ)& B, long verbose = 0);
long LLL(ZZ& det, matrix(ZZ)& B, matrix(ZZ)& U, long verbose = 0);

long LLL(ZZ& det, matrix(ZZ)& B, long a, long b, long verbose = 0);
long LLL(ZZ& det, matrix(ZZ)& B, matrix(ZZ)& U, long a, long b, 
         long verbose = 0);


long image(ZZ& det, matrix(ZZ)& B, long verbose = 0);
long image(ZZ& det, matrix(ZZ)& B, matrix(ZZ)& U, long verbose = 0);


typedef long (*LLLCheckFct)(const vector(ZZ)&); 

long LLL_FP(matrix(ZZ)& B, double delta = 0.99, long deep = 0, 
           LLLCheckFct check = 0);
long LLL_FP(matrix(ZZ)& B, matrix(ZZ)& U, double delta = 0.99, long deep = 0,
           LLLCheckFct check = 0);


long BKZ_FP(matrix(ZZ)& BB, double delta=0.99, long BlockSize=10, long prune=0, 
         LLLCheckFct check = 0);
long BKZ_FP(matrix(ZZ)& BB, matrix(ZZ)& U, double delta=0.99, 
         long BlockSize=10, long prune=0, LLLCheckFct check = 0);

long LLL_XD(matrix(ZZ)& B, double delta = 0.99, long deep = 0,
           LLLCheckFct check = 0);
long LLL_XD(matrix(ZZ)& B, matrix(ZZ)& U, double delta = 0.99, long deep = 0,
           LLLCheckFct check = 0);


long BKZ_XD(matrix(ZZ)& BB, double delta=0.99, long BlockSize=10, long prune=0,
         LLLCheckFct check = 0);
long BKZ_XD(matrix(ZZ)& BB, matrix(ZZ)& U, double delta=0.99,
         long BlockSize=10, long prune=0, LLLCheckFct check = 0);


long LLL_RR(matrix(ZZ)& B, double delta = 0.99, long deep = 0,
           LLLCheckFct check = 0);
long LLL_RR(matrix(ZZ)& B, matrix(ZZ)& U, double delta = 0.99, long deep = 0,
           LLLCheckFct check = 0);


long BKZ_RR(matrix(ZZ)& BB, double delta=0.99, long BlockSize=10, long prune=0,
         LLLCheckFct check = 0);

long BKZ_RR(matrix(ZZ)& BB, matrix(ZZ)& U, double delta=0.99,
         long BlockSize=10, long prune=0, LLLCheckFct check = 0);






#endif
