C
C      ________________________________________________________
C     |                                                        |
C     |  SOLVE GENERAL UNDERDETERMINED LINEAR SYSTEM OF M EQS. |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --FACTORIZATION COMPUTED BY SUBROUTINE QR|
C     |                 OF THE COEFFICIENT MATRIX TRANSPOSE    |
C     |                                                        |
C     |         B     --RIGHT SIDE                             |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         X     --SOLUTION (CAN BE IDENTIFIED WITH B     |
C     |                 ALTHOUGH THE RIGHT SIDE IS DESTROYED)  |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |________________________________________________________|
C
      SUBROUTINE UNDER(X,A,B)
      REAL  A(1),B(1),X(1),T
      INTEGER H,I,J,K,L,M,N,O
      T = A(1)
      IF ( ABS(T) .EQ. 3230 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST QR FACTOR COEFFICIENT MATRIX'
      WRITE(6,*) 'BEFORE SOLVING SYSTEM'
      STOP
10    IF ( T .GT. 0. ) GOTO 20
      WRITE(6,*) 'SINGULAR SYSTEM - COMPUTE REGULARIZED SOLUTION'
      WRITE(6,*) '(SEE SECTION 6-11)'
      STOP
20    M = A(2)
      N = A(3)
      IF ( M .GE. N ) GOTO 30
      WRITE(6,*) 'ERROR: THE NUMBER OF EQUATIONS IS GREATER THAN'
      WRITE(6,*) 'THE NUMBER OF UNKNOWNS. FOR AN UNDERDETERMINED'
      WRITE(6,*) 'SYSTEM, THERE ARE FEWER EQUATIONS THAN UNKNOWNS'
      STOP
30    IF ( M .GT. 1 ) GOTO 40
      X(1) = B(1)/A(4)
      RETURN
40    DO 50 I = 1,N
50         X(I) = B(I)
      O = M + 1
      L = N
      IF ( M .EQ. N ) L = N - 1
      IF ( L .EQ. 0 ) GOTO 70
      K = 3 + O*N
C     ----------------------------------
C     |*** PERFORM PIVOT OPERATIONS ***|
C     ----------------------------------
      DO 60 I = 1,L
           J = A(I+K)
           T = X(J)
           X(J) = X(I)
60         X(I) = T
70    K = 3
      J = 1
      T = X(1)
C     ---------------------------------
C     |*** SOLVE TRIANGULAR SYSTEM ***|
C     ---------------------------------
80    X(J) = T/A(J+K)
      K = K + O
      IF ( J .EQ. N ) GOTO 100
      H = J
      J = J + 1
      T = X(J)
      DO 90 I = 1,H
90         T = T - A(K+I)*X(I)
      GOTO 80
100   IF ( M .EQ. N ) GOTO 120
      J = N + 1
      DO 110 I = J,M
110        X(I) = 0.
120   K = 4 + L*O
C     -----------------------------------------
C     |*** APPLY ORTHOGONAL TRANSFORMATION ***|
C     -----------------------------------------
130   K = K - O
      T = 0.
      DO 140 I = L,M
140        T = T + A(K+I)*X(I)
      DO 160 I = L,M
160        X(I) = X(I) - T*A(K+I)
      L = L - 1
      IF ( L .GT. 0 ) GOTO 130
      RETURN
      END
