C
C      ________________________________________________________
C     |                                                        |
C     |       INVERT A SYMMETRIC MATRIX WITHOUT PIVOTING       |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |        V     --ARRAY PACKED WITH ELEMENTS CONTAINED IN |
C     |                EACH ROW, ON DIAGONAL AND TO RIGHT, OF  |
C     |                COEFFICIENT MATRIX                      |
C     |                (LENGTH AT LEAST N(N+1)/2)              |
C     |                                                        |
C     |        N     --MATRIX DIMENSION                        |
C     |                                                        |
C     |        W     --WORK ARRAY WITH AT LEAST N ELEMENTS     |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |        V     --INVERSE STORED IN THE COMPRESSED MODE   |
C     |                DESCRIBED ABOVE                         |
C     |________________________________________________________|
C
      SUBROUTINE SVERT(V,N,W)
      REAL V(1),W(1),S,T
      INTEGER G,H,I,J,K,L,M,N
      H = N
      K = 1
10    IF ( H .EQ. 1 ) GOTO 40
C     --------------------------
C     |*** SAVE PIVOT ENTRY ***|
C     --------------------------
      S = V(K)
      K = K + H
      G = K
      H = H - 1
      M = H
      IF ( S .EQ. 0. ) GOTO 50
      J = 0
20    J = J - M
      M = M - 1
      L = G + M
      T = V(G+J)/S
C     ---------------------------
C     |*** ELIMINATE BY ROWS ***|
C     ---------------------------
      DO 30 I = G,L
30         V(I) = V(I) - T*V(I+J)
      G = L + 1
      IF ( M .GT. 0 ) GOTO 20
      GOTO 10
40    IF ( V(K) .NE. 0. ) GOTO 60
50    WRITE(6,*) 'ERROR: ZERO PIVOT ENCOUNTERED'
      STOP
C     ------------------------------------------
C     |*** SOLVE FOR ROWS OF INVERSE MATRIX ***|
C     ------------------------------------------
60    G = N + N
      DO 150 M = 1,N
           L = ((G-M)*(M-1))/2
           H = L
           K = M
           DO 70 I = M,N
70              W(I) = 0.
           W(M) = 1.
80         IF ( K .EQ. N ) GOTO 100
           T = W(K)/V(K+L)
           J = L
           L = L + N - K
           K = K + 1
           IF ( T .EQ. 0. ) GOTO 80
           DO 90 I = K,N
90              W(I) = W(I) - T*V(I+J)
           GOTO 80
C     -----------------------------------
C     |*** BACK SUBSTITUTION BY ROWS ***|
C     -----------------------------------
100        W(N) = W(N)/V(K+L)
110        IF ( K .EQ. M ) GOTO 130
           J = K
           K = K - 1
           L = L + K - N
           T = W(K)
           DO 120 I = J,N
120             T = T - W(I)*V(I+L)
           W(K) = T/V(K+L)
           GOTO 110
130        DO 140 I = M,N
140             V(I+H) = W(I)
150   CONTINUE
      RETURN
      END
