C     ________________________________________
C     |APPROXIMATE THE SEMICONDUCTOR EQUATION|
C     |AT EVENLY SPACED POINTS               |
C     ----------------------------------------
      REAL NEW(100),OLD(100),D,DIF,S,SIZE,T
      INTEGER I,N,NM1
C     BUILTIN FUNCTIONS: EXP,FLOAT
C
C        *** INPUT NUMBER OF INTERVALS ***
C
10    READ(5,*) N
      IF ( N .LT. 2 ) STOP
      IF ( N .LE. 100 ) GOTO 20
      WRITE(6,*) 'ARRAY DIMENSION EXCEEDED'
      STOP
C
C       *** PREPROCESS AND INITIALIZE VARIABLES ***
C
20    NM1 = N - 1
      D = 1./FLOAT(N)
      S = D*D
      DO 30 I = 1,N
           OLD(I) = 0.
30    CONTINUE
C
C       *** COMPUTE NEXT ITERATION ***
C
40    NEW(1) = .5*(OLD(2) + S*EXP(-OLD(1)))
      IF ( N .LE. 2 ) GOTO 60
      DO 50 I = 2,NM1
           NEW(I) = .5*(OLD(I-1) + OLD(I+1) + S*EXP(-OLD(I)))
50    CONTINUE
C
C     *** UPDATE AND TEST ERROR ***
C
60    CALL UPDATE(DIF,SIZE,NEW,OLD,NM1)
      CALL STOPIT(DIF,SIZE,4,5000)
      IF ( DIF .GT. 0 ) GOTO 40
      CALL WHATIS(DIF,SIZE)
C
C     *** PRINT THE SOLUTION ***
C
      WRITE(6,70) N
70    FORMAT(I10,'  INTERVALS',/'      T             X(T)'/)
      DO 90 I = 1,NM1
           T = I*D
           WRITE(6,80) T,NEW(I)
80         FORMAT(F10.4,F15.4)
90    CONTINUE
      WRITE(6,100)
100   FORMAT(//)
      GOTO 10
      END
