C
C      ________________________________________________________
C     |                                                        |
C     | COMPUTE THE DIAGONALIZATION OF A REAL SYMMETRIC MATRIX |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         LV    --LEADING (ROW) DIMENSION OF ARRAY V     |
C     |                                                        |
C     |         V     --COEFFICIENT MATRIX (ONLY ELEMENTS ON   |
C     |                 DIAGONAL OR BENEATH DIAGONAL ACCESSED) |
C     |                                                        |
C     |         N     --MATRIX DIMENSION                       |
C     |                                                        |
C     |         W     --WORK ARRAY WITH AT LEAST 2N ELEMENTS   |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         E     --ARRAY OF EIGENVALUES                   |
C     |                                                        |
C     |         V     --ARRAY OF EIGENVECTORS                  |
C     |                                                        |
C     |    PACKAGE SUBROUTINES: SHESS,SSIM,TDG                 |
C     |________________________________________________________|
C
      SUBROUTINE SDIAG2(E,V,LV,N,W)
      REAL E(1),V(1),W(1)
      INTEGER I,J,K,L,LV,M,N,O
      IF ( N .GT. 1 ) GOTO 10
      E(1) = V(1)
      V(1) = 1.
      RETURN
C     -----------------------------------------
C     |*** COMPRESS THE COEFFICIENT MATRIX ***|
C     -----------------------------------------
10    J = 0
      K = 1
      L = N
      M = N
      O = LV - N
20    DO 30 I = K,L
30         V(I) = V(I+J)
      K = L + 1
      M = M - 1
      L = L + M
      O = O + 1
      J = J + O
      IF ( M .GT. 0 ) GOTO 20
      M = N + 1
C     ------------------------------------
C     |*** REDUCE TO TRIDIAGONAL FORM ***|
C     ------------------------------------
      IF ( N .GT. 2 ) GOTO 40
      W(1) = V(1)
      W(2) = V(3)
      W(3) = V(2)
      V(1) = 2234
      V(2) = 2
      GOTO 50
40    CALL SHESS(W,W(M),V,N)
C     -----------------------------------------------
C     |*** COMPUTE THE SIMILARITY TRANSFORMATION ***|
C     -----------------------------------------------
50    CALL SSIM(V,LV,V)
C     --------------------------------------------
C     |*** DIAGONALIZE THE TRIDIAGONAL MATRIX ***|
C     --------------------------------------------
      CALL TDG(E,V,LV,W,W(M),N)
      RETURN
      END
