C
C      ________________________________________________________
C     |                                                        |
C     | COMPUTE THE DIAGONALIZATION OF A REAL SYMMETRIC MATRIX |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         LV    --LEADING (ROW) DIMENSION OF ARRAY V     |
C     |                                                        |
C     |         A     --ARRAY PACKED WITH ELEMENTS CONTAINED   |
C     |                 IN EACH ROW, ON DIAGONAL AND TO RIGHT, |
C     |                 OF COEFFICIENT MATRIX                  |
C     |                 FORMAT (LENGTH AT LEAST N(N+3)/2)      |
C     |                                                        |
C     |         N     --MATRIX DIMENSION                       |
C     |                                                        |
C     |         W     --WORK ARRAY WITH AT LEAST 2N ELEMENTS   |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         E     --ARRAY OF EIGENVALUES                   |
C     |                                                        |
C     |         V     --ARRAY OF EIGENVECTORS                  |
C     |                                                        |
C     |         A     --OUTPUT OF SHESS                        |
C     |                                                        |
C     |    PACKAGE SUBROUTINES: SHESS,SSIM,TDG                 |
C     |________________________________________________________|
C
      SUBROUTINE SDIAG(E,V,LV,A,N,W)
      REAL A(1),E(1),V(1),W(1)
      INTEGER LV,M,N
      M = N + 1
C     ------------------------------------
C     |*** REDUCE TO TRIDIAGONAL FORM ***|
C     ------------------------------------
      CALL SHESS(W,W(M),A,N)
C     -----------------------------------------------
C     |*** COMPUTE THE SIMILARITY TRANSFORMATION ***|
C     -----------------------------------------------
      CALL SSIM(V,LV,A)
C     --------------------------------------------
C     |*** DIAGONALIZE THE TRIDIAGONAL MATRIX ***|
C     --------------------------------------------
      CALL TDG(E,V,LV,W,W(M),N)
      RETURN
      END
