C
C      ________________________________________________________
C     |                                                        |
C     |         MULTIPLY A CIRCULANT MATRIX BY A VECTOR        |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         X     --VECTOR (COMPLEX ARRAY)                 |
C     |                                                        |
C     |         A     --EIGENVALUES COMPUTED BY OVALS          |
C     |                                                        |
C     |         N     --MATRIX DIMENSION                       |
C     |                                                        |
C     |         W     --COMPLEX WORK ARRAY WITH AT LEAST N     |
C     |                 ELEMENTS                               |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         Y     --COMPLEX PRODUCT BETWEEN MATRIX AND X   |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: CONJG                            |
C     |    PACKAGE SUBROUTINES: FFT                            |
C     |________________________________________________________|
C
      SUBROUTINE OMULT(Y,X,A,N,W)
      COMPLEX A(1),W(1),X(1),Y(1)
      REAL T
      T = N
      T = 1./T
      DO 10 I = 1,N
10         Y(I) = T*CONJG(X(I))
      CALL FFT(Y,N,W)
      DO 20 I = 1,N
20         Y(I) = CONJG(Y(I))*A(I)
      CALL FFT(Y,N,W)
      RETURN
      END
