C
C      ________________________________________________________
C     |                                                        |
C     |          THE CONJUGATE FAST FOURIER TRANSFORM          |
C     |             NEW A SUB I = SUM FROM J=1 TO N            |
C     |           EXP(-2*PI*SQRT(-1)/N)**((I-1)*(J-1))         |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --COEFFICIENTS                           |
C     |                                                        |
C     |         N     --NUMBER OF COEFFICIENTS                 |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         A     --TRANSFORMED COEFFICIENTS               |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ACOS,CEXP,CMPLX                  |
C     |________________________________________________________|
C
      SUBROUTINE FFC0(A,N,W)
      COMPLEX A(1),W(1),S,T,U,V
      INTEGER F,G,H,I,J,K,L,M,N,NP,O,P(25)
      DATA P/2,3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,61,67,71,
     1 73,79,83,89,97/
      DATA NP/25/
      M = N
      F = 0
      U = CMPLX(0.,-2.*ACOS(-1.)/N)
C     --------------------------------------------------
C     |*** SOME COMPILERS USE ARCOS INSTEAD OF ACOS ***|
C     --------------------------------------------------
10    IF ( M .EQ. 1 ) GOTO 150
      DO 20 I = 1,NP
20         IF ( (M/P(I))*P(I) .EQ. M ) GOTO 30
      L = M
      GOTO 40
30    L = P(I)
40    O = M
      M = M/L
      V = CEXP(M*U)
      S = (1.,0.)
      H = 0
      IF ( F .EQ. 1 ) GOTO 100
50    J = -H
60    T = (1.,0.)
      I = H + 1
      H = H + M
      G = J + O
      DO 70 K = I,H
70         W(K) =  (0.,0.)
80    DO 90 K = I,H
90         W(K) = W(K) + T*A(J+K)
      T = T*S
      J = J + M
      IF ( J .LT. G ) GOTO 80
      J = J - M
      S = S*V
      IF ( J+H .LT. N ) GOTO 60
      IF ( H .LT. N ) GOTO 50
      F = 1
      GOTO 10
100   J = -H
110   T = (1.,0.)
      I = H + 1
      H = H + M
      G = J + O
      DO 120 K = I,H
120        A(K) =  (0.,0.)
130   DO 140 K = I,H
140        A(K) = A(K) + T*W(J+K)
      T = T*S
      J = J + M
      IF ( J .LT. G ) GOTO 130
      J = J - M
      S = S*V
      IF ( J+H .LT. N ) GOTO 110
      IF ( H .LT. N ) GOTO 100
      F = 0
      GOTO 10
150   IF ( F .EQ. 0 ) RETURN
      DO 160 I = 1,N
160        A(I) = W(I)
      RETURN
      END
