C
C      ________________________________________________________
C     |                                                        |
C     | COMPUTE THE DIAGONALIZATION OF A GENERAL COMPLEX MATRIX|
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         LV    --LEADING (ROW) DIMENSION OF ARRAY V     |
C     |                                                        |
C     |         A     --COMPLEX ARRAY CONTAINING COEFFICIENT   |
C     |                 MATRIX (LENGTH AT LEAST 1 + N(N+2))    |
C     |                                                        |
C     |         LA    --LEADING (ROW) DIMENSION OF ARRAY A     |
C     |                                                        |
C     |         N     --DIMENSION OF MATRIX STORED IN A        |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         E     --COMPLEX ARRAY OF EIGENVALUES           |
C     |                                                        |
C     |         V     --COMPLEX ARRAY OF EIGENVECTORS          |
C     |                                                        |
C     |    PACKAGE SUBROUTINES: CAHESS,CSIM,DAG                |
C     |________________________________________________________|
C
      SUBROUTINE CDIAG(E,V,LV,A,LA,N)
      INTEGER I,J,K,L,LA,LV,M,N
      COMPLEX A(1),E(1),V(LV,1)
      CALL CAHESS(A,LA,N,E)
      CALL CSIM(V,LV,A)
      J = 2
      K = 1
      M = 1
      L = 2
10    DO 20 I = M,L
20         A(I) = A(I+J)
      M = L + 1
      J = J + N - K
      K = K + 1
      L = M + K
      IF ( K .LT. N ) GOTO 10
      IF ( K .GT. N ) GOTO 30
      L = L - 1
      GOTO 10
30    I = (N*(N+3))/2
      J = I + N
      K = J + 1 + N/2
      CALL DAG(E,V,LV,A,N,A(K),A(J),A(I))
      RETURN
      END
