/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include <stdio.h>

#include <varargs.h>
#define MAXARGS 100

FILE *monfile ;
int am_monitoring = 0 ;
extern int prlevel ;
extern int prcomment ;

int flushnum ;  /* everytime prflush is called, this is incremented by 1.
		   Once this number is 50, a newline is displayed.  Also, 
		   This number is reset to 0 before every command, in shell.c*/

static doPr(fmt, ap, fil)
char *fmt ;
va_list *ap ;
FILE *fil ;
{
    if ((fil == stdout) && (prlevel > 0)) return ;
    doPrint(fmt, ap, fil) ;  /* will print to monitor file if appropriate */
}

fprint(va_alist)
va_dcl
{
    va_list ap ;
    FILE *fil ;
    char *fmt ;

    va_start(ap) ;
    fil = va_arg(ap, FILE *) ;
    fmt = va_arg(ap, char *) ;
    doPr(fmt, &ap, fil) ;
    va_end(ap) ;
}

print(va_alist)
va_dcl
{
    va_list ap ;
    char *fmt ;

    va_start(ap) ;
    fmt = va_arg(ap, char *) ;
    doPr(fmt, &ap, stdout) ;
    va_end(ap) ;
}


fprintnew(va_alist)
va_dcl
{
    va_list ap ;
    FILE *fil ;
    char *fmt ;

    va_start(ap) ;
    fil = va_arg(ap, FILE *) ;
    fmt = va_arg(ap, char *) ;
    fnewline(fil) ;
    doPr(fmt, &ap, fil) ;
    va_end(ap) ;
}

printnew(va_alist)
va_dcl
{
    va_list ap ;
    char *fmt ;

    va_start(ap) ;
    fmt = va_arg(ap, char *) ;
    newline() ;
    doPr(fmt, &ap, stdout) ;
    va_end(ap) ;
}

prinput(va_alist)
va_dcl
{
    va_list ap ;
    char *fmt ;

    va_start(ap) ;
    fmt = va_arg(ap, char *) ;
    print("! ") ;
    doPr(fmt, &ap, stdout) ;
    print(" ? ") ;
    va_end(ap) ;
}

prinput_error(va_alist)
va_dcl
{
    va_list ap ;
    char *fmt ;
    int old_prlevel ;

    va_start(ap) ;
    fmt = va_arg(ap, char *) ;

    old_prlevel = prlevel ;
    prlevel = 0 ;
    print("! ") ;
    doPr(fmt, &ap, stdout) ;
    print(" ? ") ;
    prlevel = old_prlevel ;
    va_end(ap) ;
}

int cmd_error;

prerror(va_alist)
va_dcl
{
    va_list ap ;
    char *fmt ;
    int old_prlevel ;

    va_start(ap) ;
    fmt = va_arg(ap, char *) ;

    old_prlevel = prlevel ;
    prlevel = 0 ;
    doPr(fmt, &ap, stdout) ;
    prlevel = old_prlevel ;
		cmd_error = 1;
    va_end(ap) ;
}

intflush(fmt, num)
char *fmt;
int num;
{
    /* call like printf, with format, 1 int argument */
    /* prepares so prflush can correctly count length */
    char buf[128];
    
    sprintf(buf, fmt, num);
    prflush(buf);
} /* new 24feb89 DB */

extern int linesize ; /* new 24feb89 DB */

static long last_fflush = 0;

prflush(va_alist)
va_dcl
{
    va_list ap ;
    char *fmt ;
    long ticks, get_ticks();
    extern int iodelay;

    /* sets flushnum correctly when no args (fmt only) */
    int len;

    va_start(ap) ;
    fmt = va_arg(ap, char *) ;
    len = strlen(fmt);
    flushnum += len;
    if (flushnum > linesize) {
	print("\n") ;
	flushnum = len ;
	newline() ; /* leave last! */
    } 
    
    doPr(fmt, &ap, stdout) ;

    if ((ticks=get_ticks()) > last_fflush + iodelay) {
      last_fflush = ticks;
      fflush(stdout) ;
    }
    va_end(ap) ;
} /* mod 24feb89 DB, 16aug93 DB */

debugpr(va_alist)
va_dcl
{
    va_list ap ;
    char *fmt ;

    int argc ;
    char **argv ;

    va_start(ap) ;
    fmt = va_arg(ap, char *) ;
    doPr(fmt, &ap, stdout) ;
    print(" = ") ;
    get_line(&argc, &argv) ;
    if (argc > 0)
      exit(0) ;
    va_end(ap) ;
}

extern int flushnum;

newline()
{
    if (prcomment > 0) {
	print("; ") ;
	flushnum += 2;
    }
} /* mod 24feb89 DB */

fnewline(fil)
FILE *fil ;
{
    if (prcomment > 0) {
	fprint(fil, "; ") ;
	flushnum += 2 ;
    }
}

monprint(va_alist)
va_dcl
{
    va_list ap ;
    char *fmt ;

    va_start(ap) ;
    fmt = va_arg(ap, char *) ;
    if (am_monitoring == 1)
	doPrint(fmt, &ap, monfile) ;
    va_end(ap) ;
}

mon_cmd(argc, argv)
int argc ;
char *argv[] ;
{
	FILE *topen();
    if (argc != 2) {
	print("monitor <file>\n") ;
	return ;
    }
    if (am_monitoring == 1) {
	print("monitoring is already being done\n") ;
	return ;
    }
    monfile = topen(argv[1], "w") ;
    if (monfile == NULL) {
	print("can't open %s\n", argv[1]) ;
	return ;
    }
    am_monitoring = 1 ;
}

end_monitor()
{
    int val ;

    am_monitoring = 0 ;
    val = fclose(monfile) ;
    if (val != 0)
	print("error writing monitor file\n") ;
}

