/* Funktion zur Zeitmessung, liefert 1/100 sec Ticks der user-Zeit,
	und eine Funktion, die eine Saat fuer den Zufallsgenerator
	liefert.

	RD, 12.09.90	*/

#include "timing.h"

#ifndef NULL
#define NULL 0
#endif

#if defined(__MWERKS__) || defined(__BORLANDC__)
#define ATARI
#endif

#ifdef ATARI
#define OK
#include <time.h>
unsigned long 
timeticks()
{
    return clock() / 2;
}
unsigned int 
timeseed()
{
    return clock();
}
#endif

/* Added by Stefan Neis, for OS/2 */
#if defined(__EMX__)
#define OK
#include <sys/types.h>
#include <sys/times.h>
#include <sys/time.h>
static struct tms buffer;
unsigned long 
timeticks()
{
    times(&buffer);
    return buffer.tms_utime;
}
unsigned int 
timeseed()
{
    struct timeval t;
    struct timezone tz;
    gettimeofday(&t, &tz);
    return (t.tv_sec) ^ (t.tv_usec);
}
#endif

#if defined(__sun__) || defined (__sun) || defined(sun)
#define OK
#include <sys/types.h>
#include <sys/times.h>
#include <sys/time.h>
static struct tms buffer;
unsigned long 
timeticks()
{
    times(&buffer);
    return (buffer.tms_utime * 100) / 60;
}
unsigned int 
timeseed()
{
    struct timeval t;
    struct timezone tz;
    gettimeofday(&t, &tz);
    return (t.tv_sec) ^ (t.tv_usec);
}
#endif

#ifdef HELIOS
#define OK
#include <time.h>
unsigned long 
timeticks()
{
    return (clock() * 100) / CLK_TCK;
}
unsigned int 
timeseed()
{
    time_t buf;
    int upper;
    buf = time(NULL);
    upper = buf >> 16;
    return buf ^ upper;
}
#endif

#if defined(__PARC__)
#define OK
#include <time.h>
unsigned long 
timeticks()
{
    return (clock() * 100) / CLOCKS_PER_SEC;
}
unsigned int 
timeseed()
{
    time_t buf;
    int upper;
    buf = time(NULL);
    upper = buf >> 16;
    return buf ^ upper;
}
#endif


#ifndef OK
#if defined(__unix__) || defined(__unix) || defined(unix)
#define OK
#include <sys/types.h>
#include <sys/times.h>
#include <sys/time.h>
#include <sys/param.h>
#ifndef HZ
#define HZ 60
#endif

static struct tms buffer;
unsigned long 
timeticks()
{
    times(&buffer);
    return (buffer.tms_utime * 100) / HZ;
}
unsigned int 
timeseed()
{
    struct timeval t;
    struct timezone tz;
    gettimeofday(&t, &tz);
    return (t.tv_sec) ^ (t.tv_usec);
}
#endif
#endif

#ifndef OK
#ifdef _AIX
#define OK
#include <sys/types.h>
#include <sys/times.h>
#include <sys/time.h>
#include <sys/param.h>
#ifndef HZ
#define HZ 60
#endif

static struct tms buffer;
unsigned long 
timeticks()
{
    times(&buffer);
    return (buffer.tms_utime * 100) / HZ;
}
unsigned int 
timeseed()
{
    struct timeval t;
    struct timezone tz;
    gettimeofday(&t, &tz);
    return (t.tv_sec) ^ (t.tv_usec);
}
#endif
#endif
