 # Ralf Dentzer, 1.3.93
 # DigitType  DigitVecMult (res, a, m, l)
 #			    $4, $5, $6, $7
 #	DigitType *res, *a, m;
 #	int l;
 #     /*	res[0..l-1] = a[0..l-1]*m; return CARRY;   */
 #     /* Special function for multiple digit multiplication */
 # {	Digit_t carry=0, tmp, tmp2,    accu, aa;
 #		$3, 	      $11-$12, $8,   $14
 #	if (l==0)
 #		return 0;
 #	tmp=*a * m;
 #	l--;
 #	a++;
 #	aa=*a;
 #      for ( ; l>0; l--) {
 #		tmp2=tmp;
 #		tmp=aa*m;
 #		a++;
 #		aa=*a;
 #		accu = tmp2+carry;
 #		carry = (accu < carry);
 #		*res ++ = accu;
 #	}
 #	accu=tmp + carry;
 #	carry=(accu<tmp);
 #	*res=accu;
 #	return carry;
 #} 
	.text

        .set    noreorder

	.globl	DigitVecMult
	.ent	DigitVecMult
DigitVecMult:
        .frame  $sp, 0, $31
	lw	$14, 0($5)		# aa=*a;
	bne	$7, 0, $32		# if (l==0)
	move	$3, $0			# carry=0;	DELAY
	j	$31			# return
	move	$2, $0			# 0;		DELAY
$32:
	multu	$14, $6			# tmp=aa * m;
	addu	$7, $7, -1		# l--;
	ble	$7, 0, $34		# for ( ; l>0; l--) {
	addu	$5, $5, 4		# a++;		DELAY
$33:
	lw	$14, 0($5)		# aa=*a;
	mflo	$11			#
	mfhi	$12			# tmp2=tmp;
	addu	$5, $5, 4		# a++;
	addu	$8, $3, $11		# accu=carry + LOW(tmp2);
	multu	$14, $6			# tmp=aa*m;
	sltu	$3, $8, $3		# carry=(accu < carry)
	sw	$8, 0($4)		# *res=accu;
	addu	$4, $4, 4		# res++;
	addu	$7, $7, -1		# l--;
	bgt	$7, 0, $33		# } for ( ; l>0; l--)
	addu	$3, $3, $12		# carry += HIGH(tmp2);
$34:
	mflo	$11
	mfhi	$12
	addu	$8, $3, $11		# accu=carry + LOW(tmp);
	sltu	$3, $8, $3		# carry=(accu<carry);
	sw	$8, 0($4)		# *res=accu;
	j	$31			# return
	addu	$2, $3, $12		# carry + HIGH(tmp);

	.end	DigitVecMult

        .set    reorder
