//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : bigint_def.h 
// Author      : Thomas Papanikolaou (TP)
// Last change : TP, Oct 4 1995, initial version
//

#ifndef LIDIA_BIGINT_DEF_H
#define LIDIA_BIGINT_DEF_H

/**
** The next include MUST remain in this file in THIS position.
**/

#include <LiDIA/lidia.h>

/**
** include here the include file of the C multiple precision integers
** and define integer_type_name to be the integer type we have. Define 
** base_digit to
**
** For example write something like
**
** #include "integer_include_file.h"
** #define integer_type_name  	your_integer_type_name 
**
**/

/* We need the define, because gmp-impl.h does not
   set a define and udigit_def.h also must include
   those header files. */

#ifndef LIDIA_HAVE_GMP_H
#define LIDIA_HAVE_GMP_H
extern "C" {
#include <LiDIA/gmp.h>
#include <LiDIA/gmp-impl.h>
#include <LiDIA/longlong.h>
#include <LiDIA/gmp-mparam.h>
};
#endif

/*
extern "C" {
#include "gmp.h"
#include "gmp-impl.h"
#include "longlong.h"
#include "gmp-mparam.h"
};
*/


#define integer_type_name       MP_INT
#define base_digit       mp_limb_t

#endif
