#if defined(HAVE_MAC_DIRS) || defined(__MWERKS__)
#include <LiDIA:Fp_polynomial.h>
#include <LiDIA:Fp_polynomial_util.h>
#include <LiDIA:factorization.h>
#else
#include <LiDIA/Fp_polynomial.h>
#include <LiDIA/Fp_polynomial_util.h>
#include <LiDIA/factorization.h>
#endif


main(lidia_size_t argc, char **argv)
{
    cout << "This program computes the factorization of a polynomial over\n";
    cout << "a finite prime field using the Berlekamp algorithm.\n";
    cout << "If the flag '-v' is used, additional information (such as\n";
    cout << "timinigs) are printed during the factorization process.\n\n";


    lidia_size_t verbose = 0;

    if (argc > 1 && !strcmp(argv[1], "-v"))
    {
	verbose = 1;
	single_factor < Fp_polynomial >::set_verbose_mode(1);
    }
    else
	single_factor < Fp_polynomial >::set_verbose_mode(0);


    cout << "Please enter a polynomial (example: 17x^54 - 3x^2 + 1) :\n";
    Fp_polynomial f;
    cin >> f;

    factorization < Fp_polynomial > factors;

    my_timer t;
    t.start("total time: ");

    berlekamp(factors, f);

    if (verbose) t.stop();

    cout << "factorization :\n";
    cout << factors << "\n";

    Fp_polynomial ff;

    ff = factors.value();
    if (f != ff)
    {
	cerr << "Incorrect factorization!!\n";
	cout << "Product of factors :";
	cout << ff << endl;
	cout << "should be :" << endl;
	cout << f << endl;
    }
}
