//
// LiDIA - a library for computational number theory
//   Copyright (c) 1994, 1995 by the LiDIA Group
//
// File        : error_handling.h
// Author      : Patrick Theobald (PT)
// Last change : PT, Oct 28, 1995, initial version
//             

/*
$Id: xerror.h,v 1.8 1996/11/13 18:16:06 neis Exp $
*/

#ifndef LIDIA_ERROR_HANDLING_H
#define LIDIA_ERROR_HANDLING_H

#include <LiDIA/error.h>
#include <LiDIA/bigint.h>

inline void lidia_error_handler_para(const char *file, const char *msg)
{lidia_error_handler(file,msg);}

inline void lidia_error_handler_para(const char *proto, const char *file, const char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const char& para1, const char *name_1, const char *cond1, 
				     const char *proto, const char *file, const char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name_1 << " = " << para1 << "\t  condition: " << cond1 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const bigint& para1, const char *name_1, const char *cond1, 
				     const char *proto, const char *file, const char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name_1 << " = " << para1 << "\t  condition: " << cond1 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const int& para1, const char *name_1, const char *cond1, 
				     const char *proto, const char *file, const char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name_1 << " = " << para1 << "\t  condition: " << cond1 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const float & para1, const char *name_1, const char *cond1, 
				     const char *proto, const char *file, const char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name_1 << " = " << para1 << "\t  condition: " << cond1 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const unsigned long & para1, const char *name_1, const char *cond1, 
				     const char *proto, const char *file, const char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name_1 << " = " << para1 << "\t  condition: " << cond1 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const char *const & para1, const char *name_1, const char *cond1, 
				     const char *proto, const char *file, const char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name_1 << " = " << para1 << "\t  condition: " << cond1 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const int & para1, const char *name_1, const char *cond1, 
				     const char & para2, const char *name_2, const char *cond2, 
				     const char *proto, const char *file, const char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name_1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name_2 << " = " << para2 << "\t  condition: " << cond2 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const int & para1, const char *name_1, const char *cond1, 
				     const int & para2, const char *name_2, const char *cond2, 
				     const char *proto, const char *file, const char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name_1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name_2 << " = " << para2 << "\t  condition: " << cond2 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const int & para1, const char *name_1, const char *cond1, 
				     const unsigned long & para2, const char *name_2, const char *cond2, 
				     const char *proto, const char *file, const char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name_1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name_2 << " = " << para2 << "\t  condition: " << cond2 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const int & para1, const char *name_1, const char *cond1, 
				     const int & para2, const char *name_2, const char *cond2,
				     const int & para3, const char *name_3, const char *cond3,
				     const char *proto, const char *file, const char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name_1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name_2 << " = " << para2 << "\t  condition: " << cond2 << endl;
  cerr << "actual parameter: " << name_3 << " = " << para3 << "\t  condition: " << cond3 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const int & para1, const char *name_1, const char *cond1, 
				     const int & para2, const char *name_2, const char *cond2,
				     const char * para3, const char *name_3, const char *cond3,
				     const char *proto, const char *file, const char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name_1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name_2 << " = " << para2 << "\t  condition: " << cond2 << endl;
  cerr << "actual parameter: " << name_3 << " = " << para3 << "\t  condition: " << cond3 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}


inline void lidia_error_handler_para(const int & para1, const char *name_1, const char *cond1, 
				     const int & para2, const char *name_2, const char *cond2,
				     const int & para3, const char *name_3, const char *cond3,
				     const int & para4, const char *name_4, const char *cond4,
				     const char *proto, const char *file, const char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name_1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name_2 << " = " << para2 << "\t  condition: " << cond2 << endl;
  cerr << "actual parameter: " << name_3 << " = " << para3 << "\t  condition: " << cond3 << endl;
  cerr << "actual parameter: " << name_4 << " = " << para4 << "\t  condition: " << cond4 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const int & para1, const char *name_1, const char *cond1, 
				     const int & para2, const char *name_2, const char *cond2,
				     const int & para3, const char *name_3, const char *cond3,
				     const int & para4, const char *name_4, const char *cond4,
				     const char * para5, const char *name_5, const char *cond5,
				     const char *proto, const char *file, const char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name_1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name_2 << " = " << para2 << "\t  condition: " << cond2 << endl;
  cerr << "actual parameter: " << name_3 << " = " << para3 << "\t  condition: " << cond3 << endl;
  cerr << "actual parameter: " << name_4 << " = " << para4 << "\t  condition: " << cond4 << endl;
  cerr << "actual parameter: " << name_5 << " = " << para5 << "\t  condition: " << cond5 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const int & para1, const char *name_1, const char *cond1, 
				     const int & para2, const char *name_2, const char *cond2,
				     const int & para3, const char *name_3, const char *cond3,
				     const int & para4, const char *name_4, const char *cond4,
				     const int & para5, const char *name_5, const char *cond5,
				     const char *proto, const char *file, const char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name_1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name_2 << " = " << para2 << "\t  condition: " << cond2 << endl;
  cerr << "actual parameter: " << name_3 << " = " << para3 << "\t  condition: " << cond3 << endl;
  cerr << "actual parameter: " << name_4 << " = " << para4 << "\t  condition: " << cond4 << endl;
  cerr << "actual parameter: " << name_5 << " = " << para5 << "\t  condition: " << cond5 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}


inline void lidia_error_handler_para(const int & para1, const char *name_1, const char *cond1, 
				     const int & para2, const char *name_2, const char *cond2,
				     const int & para3, const char *name_3, const char *cond3,
				     const int & para4, const char *name_4, const char *cond4,
				     const int & para5, const char *name_5, const char *cond5,
				     const int & para6, const char *name_6, const char *cond6,
				     const char *proto, const char *file, const char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name_1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name_2 << " = " << para2 << "\t  condition: " << cond2 << endl;
  cerr << "actual parameter: " << name_3 << " = " << para3 << "\t  condition: " << cond3 << endl;
  cerr << "actual parameter: " << name_4 << " = " << para4 << "\t  condition: " << cond4 << endl;
  cerr << "actual parameter: " << name_5 << " = " << para5 << "\t  condition: " << cond5 << endl;
  cerr << "actual parameter: " << name_6 << " = " << para6 << "\t  condition: " << cond6 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const int & para1, const char *name_1, const char *cond1, 
				     const int & para2, const char *name_2, const char *cond2,
				     const int & para3, const char *name_3, const char *cond3,
				     const int & para4, const char *name_4, const char *cond4,
				     const int & para5, const char *name_5, const char *cond5,
				     const int & para6, const char *name_6, const char *cond6,
				     const int & para7, const char *name_7, const char *cond7,
				     const int & para8, const char *name_8, const char *cond8,
				     const int & para9, const char *name_9, const char *cond9,
				     const int & para10, const char *name_10, const char *cond10,
				     const char *proto, const char *file, const char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name_1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name_2 << " = " << para2 << "\t  condition: " << cond2 << endl;
  cerr << "actual parameter: " << name_3 << " = " << para3 << "\t  condition: " << cond3 << endl;
  cerr << "actual parameter: " << name_4 << " = " << para4 << "\t  condition: " << cond4 << endl;
  cerr << "actual parameter: " << name_5 << " = " << para5 << "\t  condition: " << cond5 << endl;
  cerr << "actual parameter: " << name_6 << " = " << para6 << "\t  condition: " << cond6 << endl;
  cerr << "actual parameter: " << name_7 << " = " << para7 << "\t  condition: " << cond7 << endl;
  cerr << "actual parameter: " << name_8 << " = " << para8 << "\t  condition: " << cond8 << endl;
  cerr << "actual parameter: " << name_9 << " = " << para9 << "\t  condition: " << cond9 << endl;
  cerr << "actual parameter: " << name_10 << " = " << para10 << "\t  condition: " << cond10 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const int & para1, const char *name_1, const char *cond1, 
                                     const char * para2, const char *name_2, const char *cond2, 
                                     const char *proto, const char *file, const char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name_1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name_2 << " = " << para2 << "\t  condition: " << cond2 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file,  msg);
}

#endif
