#include <LiDIA/polynomial.h>
#include <LiDIA/polynomial.c>
#include <LiDIA/random.h>

/**
 ** assignment
 **/

polynomial <bigint> & polynomial <bigint>::operator = (const base_polynomial <bigint> &a)
{
  debug_handler_l("polynomial<bigint>",
		  "operator =(const base_polynomial <bigint> &)", -1);
  if (deg != a.degree()){
    delete[] coeff;
    deg = a.degree();
    coeff = new bigint[deg + 1];
  }
  for (register lidia_size_t i = 0; i <= deg; i++)
    coeff[i] = a[i];
  return *this;
}


#ifdef __GNUG__
  template class base_polynomial <bigint>;
  template base_polynomial < bigint > operator + (const base_polynomial < bigint > &a,
				      const base_polynomial < bigint > &b);
  template base_polynomial < bigint > operator - (const base_polynomial < bigint > &a,
				      const base_polynomial < bigint > &b);

  template base_polynomial < bigint > operator * (const base_polynomial < bigint > &a,
				      const base_polynomial < bigint > &b);
  template void power(base_polynomial < bigint > & c, 
		    const base_polynomial < bigint > & a, const bigint & b);

  template base_polynomial < bigint > derivation(const base_polynomial < bigint > &a);

  template istream & operator >> (istream &, base_polynomial < bigint > &);
  template ostream & operator << (ostream &, const base_polynomial < bigint > &);

#endif

void polynomial <bigint>::operator /= (const base_polynomial <bigint> &a)
{
  *this = *this / a;
}

void polynomial <bigint>::operator /= (const bigint &a)
{
  *this = *this / a;
}

void power_mod(polynomial <bigint> & c, 
	       const base_polynomial <bigint> & a, const bigint & b,
	       const base_polynomial <bigint> & f)
{
  bigint exponent;
  polynomial <bigint> multiplier;
  if (b.is_negative())
    c.assign_zero();
  else if (b.is_zero() || a.is_one())
    c.assign_one();
  else{
    exponent.assign(b);
    multiplier = a;
    c.assign_one();
    while (exponent.is_gt_zero()){
      if (!exponent.is_even()){
	c *= multiplier;
	c %= f;
      }
      multiplier *= multiplier;
      multiplier %= f;
      exponent.divide_by_2();
    }
  }
}

/**
 ** Division
 **/

void div_rem(polynomial <bigint> &q, polynomial <bigint> &r,
	      const base_polynomial <bigint> &aa, const base_polynomial <bigint> &bb)
{
    debug_handler_l("polynomial", "div_rem(...)", -1);
    lidia_size_t deg_a = aa.degree(), deg_b = bb.degree();
    lidia_size_t deg_ab = deg_a - deg_b;
    if (bb.is_zero())
	lidia_error_handler("polynomial", "div_rem::division by zero");

    bigint pow(1);
    if (deg_ab < 0){
	r = aa;
	q.assign_zero();
    }
    else{
	bigint *ap, *bp, *qp, *rp, x, y;
	lidia_size_t i, j, e = deg_ab + 1;

	polynomial <bigint> a=aa, b=bb;
	q.set_degree(deg_ab);
	r.set_degree(deg_a);

	x = b[deg_b];

	for (i = deg_a + 1, rp = r.coeff, ap = a.coeff; i; i--, ap++, rp++)
	    *rp = *ap;

	for (i = 0, qp = q.coeff + deg_ab; i <= deg_ab; i++, qp--, e--){
	    rp = r.coeff + deg_a - i;
	    y = (*rp);
	    q = x * q;
	    r = x * r;
	    *qp =y;
	    for (j = deg_b + 1, bp = b.coeff + deg_b; j; j--, rp--, bp--)
		*rp -= y * (*bp);
	}
	q.remove_leading_zeros();
	power(pow, x, e);
	q *= pow;
    }
    r.remove_leading_zeros();
    r *= pow;
}

polynomial <bigint> operator / (const base_polynomial <bigint> &a,
				const bigint & b)
{
    bigint *ap, *cp;
    bigint r;
    lidia_size_t deg_a = a.degree();
    lidia_size_t i;
    
    polynomial <bigint> c;
    c.set_degree(deg_a);
    for (i = 0, ap = ((polynomial<bigint>*)(&a))->coeff, cp = c.coeff; i <= deg_a; i++, ap++, cp++){
	div_rem (*cp, r, *ap, b);
	if (!(r.is_zero())) lidia_error_handler("polynomial <bigint>",
			     "polynomial / bigint::division error");
    }
    return c;
}

/**
 ** Gcd's
 **/

polynomial <bigint> gcd(const base_polynomial <bigint> &aa,
			const base_polynomial <bigint> &bb)
// OOOh, sooooo slooowwww.... (Most naive version, should be improved
//			       to use either the sub-resultant-algorithm
//                             or modular techniques)
{
    debug_handler_l("polynomial<bigint>", "gcd(...)", -1);
    if (bb.is_zero())
	return aa;
    polynomial <bigint> q, r, a = pp(aa), b = pp(bb);
    bigint cd = gcd(cont(aa), cont(bb));
    do{
	div_rem(q, r, a, b);
	a = b;
	b = pp(r);
    } while (!b.is_zero());
    return cd * a;
}

polynomial <bigint> xgcd(polynomial <bigint> &x,
			 polynomial <bigint> &y,
			 const base_polynomial <bigint> &aa,
			 const base_polynomial <bigint> &bb)
// OOOh, sooooo slooowwww.... (Most naive version, should be improved
//			       to use sub-resultant-algorithm........)
{
    polynomial <bigint> u0, v0, u1, v1, u2, v2, q, r, a=aa,b=bb;
    
    if (b.is_zero()){
	x.assign_one();
	y.assign_zero();
	return a;
    }
    u1.assign_one();
    v1.assign_zero();
    u2.assign_zero();
    v2.assign_one();
    
    do{
	div_rem(q, r, a, b);
	a = b;
	b = pp(r);
	u0 = u2;
	v0 = v2;
	u2 = pp(u1 - q * u2);
	v2 = pp(v1 - q * v2);
	u1 = u0;
	v1 = v0;
    } while (!b.is_zero());
    x = u1;
    y = v1;
    return a;
}

polynomial <bigint> operator % (const base_polynomial <bigint> &a,
				const base_polynomial <bigint> &b)
{
  polynomial <bigint> q, r;
  div_rem(q, r, a, b);
  return r;
}

polynomial <bigint> operator % (const base_polynomial <bigint> &a,
				const bigint &b)
{
    bigint *ap, *cp;
    bigint r;
    register lidia_size_t deg_a = a.degree();
    register lidia_size_t i;
    
    polynomial <bigint> c;
    c.set_degree(deg_a);

    for (i = 0, ap = ((polynomial<bigint>*)(&a))->coeff, cp = c.coeff; i <= deg_a; i++, ap++, cp++){
	remainder (*cp, *ap, b);
	if (cp->is_negative()) add(*cp,*cp,b);
    }
    return c;
}

void div_rem(polynomial <bigint> &q, polynomial <bigint> &r,
	     const base_polynomial <bigint> &aa, const base_polynomial <bigint> &bb,
	     const bigint & p)
{
    debug_handler_l("polynomial", "div_rem(...,q)", -1);
    lidia_size_t deg_a = aa.degree(), deg_b = bb.degree();
    lidia_size_t deg_ab = deg_a - deg_b;
    if (bb.is_zero())
	lidia_error_handler("polynomial", "div_rem::division by zero");
    if (deg_ab < 0){
	r = aa;
	q.assign_zero();
    }
    else{
	bigint *ap, *bp, *qp, *rp, x, y;
	lidia_size_t i, j;

	polynomial <bigint> a = aa, b = bb;
	q.set_degree(deg_ab);
	r.set_degree(deg_a);

	::xgcd(x, y, b.coeff[deg_b], p);
	if (x.is_lt_zero())
	    ::add(x, x, p);
	
	for (i = deg_a + 1, rp = r.coeff, ap = a.coeff; i; i--, ap++, rp++)
	    *rp = *ap;
	
	for (i = 0, qp = q.coeff+deg_ab; i <= deg_ab; i++, qp--){
	    rp = r.coeff + deg_a - i;
	    y =x * (*rp)%p;
	    if (y.is_lt_zero())
		::add(y, y, p);
	    *qp = y;
	    for (j = deg_b + 1, bp = b.coeff + deg_b; j; j--, rp--, bp--){
		*rp -= y * (*bp);
		*rp %=p;
		if (rp->is_lt_zero())
		    ::add(*rp, *rp, p);
	    }
	}
	q.remove_leading_zeros();
    }
    r.remove_leading_zeros();
}

void power(polynomial <bigint> & c, const base_polynomial <bigint> & a,
	   const bigint & b, const bigint & p)
{
    bigint exponent;
    polynomial <bigint> multiplier;
    if (b.is_negative())
	c.assign_zero();
    else if (b.is_zero() || a.is_one())
	c.assign_one();
    else{
	exponent.assign(b);
	multiplier = a;
	c.assign_one();
	while (exponent.is_gt_zero()){
	    if (!exponent.is_even()){
		c *= multiplier;
		c %= p;
	    }
	    multiplier *= multiplier;
	    multiplier %= p;
	    exponent.divide_by_2();
	}
    }
}

void power_mod(polynomial <bigint> & c, 
	       const base_polynomial <bigint> & a, const bigint & b,
	       const base_polynomial <bigint> & f, const bigint & p)
{
    bigint exponent;
    polynomial <bigint> multiplier, garbage;
    if (b.is_negative())
	c.assign_zero();
    else if (b.is_zero() || a.is_one())
	c.assign_one();
    else{
	exponent.assign(b);
	multiplier = a;
	c.assign_one();
	while (exponent.is_gt_zero()){
	    if (!exponent.is_even()){
		c *= multiplier;
		c %= p;
		div_rem(garbage, c, c, f, p);
	    }
	    multiplier *= multiplier;
	    multiplier %= p;
	    div_rem(garbage, multiplier, multiplier, f, p);
	    exponent.divide_by_2();
	}
    }
}

polynomial <bigint> gcd(const base_polynomial <bigint> &aa,
			const base_polynomial <bigint> &bb, const bigint & p)
{
    polynomial <bigint> a = aa%p, b = bb%p;
    if (b.is_zero())
	return a;
    polynomial <bigint> q, r;
    do{
	div_rem(q, r, a, b, p); // div_rem mod p!
	a = b;
	b = r;
    } while (!b.is_zero());

    bigint x,y;
    ::xgcd(x, y, a.coeff[a.deg], p);
    if (x.is_lt_zero())
	::add(x, x, p);
	
    bigint *ap =a.coeff;
    for (register lidia_size_t i = a.deg + 1; i; i--, ap++){
	    multiply(*ap, *ap, x);
	    remainder(*ap, *ap, p);
	    if (ap->is_lt_zero())
		::add(*ap, *ap, p);
    }
    return a;
}

void squarefree_factor(const base_polynomial <bigint> &f,
		       polynomial < bigint> * fa, const bigint & p)
{
  debug_handler_c("polynomial","in friend-function squarefree_factor(...)",
		  1, cout << "Factoring "<<f <<" mod "<<p);
		  
      register lidia_size_t i, j;
      polynomial <bigint> d, t, r, v, w;
      lidia_size_t e, k;
      lidia_size_t p_size_t;
      int step2;

      e=1;

      base_polynomial <bigint> t0 = f;
      for (i=1;i<=f.degree();i++){
	  fa[i].assign_one();
      }

      step2=1;
      do{
	if (step2){
	  debug_handler_c("polynomial","squarefree_factor",-2,
			  cout << "STEP 2 : t0="<<t0<<flush);
	  if (t0.degree()==0) break;
	  d = derivation(t0)%p;         // derivation
	  debug_handler_c("polynomial","squarefree_factor",-2,
			  cout << "STEP 2 : derivation (p)="<<d<<flush);
	  t = gcd(t0,d,p);    // gcd
	  debug_handler_c("polynomial","squarefree_factor",-2,
			  cout << "STEP 2 : gcd ="<<t<<flush);

	  div_rem(v,r,t0,t,p); 
	  debug_handler_c("polynomial","squarefree_factor",-2,
			  cout << "STEP 2 : quotient ="<<v<<flush);
	  k=0;
	}

	if (v.degree()==0){                // derivation=0
	  if (t.degree()==0) break;
	  if (p.sizetify(p_size_t)){
	    lidia_error_handler_c("polynomial","squarefree_factor(....)"
				  "::error in sizetify",
				  cout << p << " is not an lidia_size_t.";
				  cout << endl);
	  }

	  t0.set_degree(t.degree()/p_size_t);
	  for (j=0;j<=t.degree();j+=p_size_t)
	    t0[j/p_size_t]=t[j];

	  debug_handler_c("polynomial","squarefree_factor",-2,
			  cout << "STEP 3 : t ="<<t<<flush);
	  e=p_size_t*e;
	  step2=1;
	  continue;
	}

	k++;
	debug_handler_c("polynomial","squarefree_factor",-2,
			cout << "STEP 4 : k =" << k << endl<<flush);
	if (bigint(k) % p==0){
	  div_rem(t,r,t,v,p); 
	  k++;
	}
	w = gcd(t,v,p);
	debug_handler_c("polynomial","squarefree_factor",-2,
			cout << "STEP 5 : w ="<<w<< "Now dividing ";
			cout<<v << " by "<<w<<endl<<flush);
	div_rem(fa[e*k],r,v,w,p); 
	debug_handler_c("polynomial","squarefree_factor",-2,
			cout << "Result is ");
	debug_handler_c("polynomial","squarefree_factor",-2,
			cout << "STEP 5 : fa["<<e*k<<"]="<<fa[e*k];
			cout << " with remainder "<< r << endl << flush);
	v = w % p;
	debug_handler_c("polynomial","squarefree_factor",-2,
			cout << "Now dividing "<<t<<" by "<<v<<endl<<flush);
	div_rem(t,r,t,v,p); 
	debug_handler_c("polynomial","squarefree_factor",-2,
			cout << "Result is ");
	debug_handler_c("polynomial","squarefree_factor",-2,
			cout << "STEP 5 : t ="<<t;
			cout << " with remainder "<< r << endl << flush);
	step2=0;
      }
      while (1);

}

int ddf(const base_polynomial <bigint> &f0,
	polynomial < bigint> * fa, const bigint & p)
    /* return 1 means the polynomial f is not squarefree mod p */
    /*          or    the polynomial f has 0 as its root       */
    /* return 0 means h[i] contains the number of irreducible factors 
       of degree i */
    /* "Computational algebraic number theory"(M. Pohst)Birkhaeuser Verlag */
{
    int i,j;
    polynomial <bigint> f1, f, d, h, q, r;
    bigint p_pow;

    f = f0 % p;
    if (f[0]==0){
       return 1; /* divisible by X */
    }

    f1 = derivation(f) % p;     /* coefficients of f' in af1 */

    d = gcd(f, f1, p);
					  /* gcd(f,f') */
    if (d.deg>0){
	return 1;   /* f not even squarefree */
    }

    // Now, we know that f is squarefree and not divisible by X

    h.assign_x();

    for (i = 1; i <= f0.degree(); i++){
	if (f.deg>>1 < i){
	    for (j=i+1;j <= f0.degree(); j++) fa[j].assign_one();
	    fa[f.deg] = f;
	    break;
	}
	debug_handler_c("polynomial","ddf",-1,
			cout << "compute "<<p<<"th power of "<<h<<endl<<flush);
	power_mod(h,h,p,f,p); /* h(X)=X^(p^i) mod (p,f) */
	debug_handler_c("polynomial","ddf",-1,
			cout << "h = X^(p^"<<i<<") mod "<<f<<" is ";
			cout << h << endl << flush);
	h.coeff[1]--;
	if (h.coeff[1]<0) h.coeff[1]+=p;
	debug_handler_c("polynomial","ddf",-1,
			cout << "X^(p^"<<i<<")-X mod "<<f;
			cout <<" is "<<h<<endl<<flush);
	d = gcd(f, h, p);
	debug_handler_c("polynomial","ddf",-1,
			cout << "gcd with f is "<<d<<endl<<flush);
	div_rem(f, r, f, d, p); 
	debug_handler_c("polynomial","ddf",-1,
			cout << "f divided by gcd: "<<f<<r<<endl<<flush);

	/* f has (deg d) / i divisors of degree i */
	fa[i] = d;
	h.coeff[1]++;
	if (h.coeff[1]>=p) h.coeff[1]-=p;
    }
    return 0; /* f is squarefree mod p */
}

void can_zass(const base_polynomial <bigint> &f,
	      polynomial < bigint> * fa, lidia_size_t d, const bigint & p,
	      lidia_size_t count)
{
    polynomial <bigint> b, garbage;
    if (p != 2){
	bigint p_pow;
	seed(p);
	do {
	    // Compute monic random t with deg(t)<= 2d-1.
	    long temp;
	    temp = random() % (2 * d - 1);	// so 0 <= temp <= 2d - 2
	    temp++;				// so 1 <= temp <= 2d - 1
	    polynomial <bigint> t;
	    t.set_degree(temp);
	    t.coeff[t.deg].assign_one();
	    for (register lidia_size_t i = 0; i < t.deg; i++)
		t.coeff[i].assign(randomize(p));
	    debug_handler_c("polynomial","can_zass",-1,
			    cout << "Trying to split " << f;
			    cout << " with " << t << endl << flush);
	    // Compute t^((p^d-1)/2) - 1;
	    power(p_pow,p,d);
	    p_pow>>=1;
	    power_mod(b,t,p_pow,f,p);
	    b.coeff[0]--;
	    if (b.coeff[0]<0) b.coeff[0]+=p;
	    debug_handler_c("polynomial","can_zass",-1,
			    cout << "t^((p^d-1)/2) - 1 is t^" << p_pow;
			    cout << " = " << b << endl << flush);
	    // Compute gcd with f;
	    b=gcd(b,f,p);
	    debug_handler_c("polynomial","can_zass",-1,
			    cout << "gcd is "<<b<<endl<<flush);
	} while (b.deg == 0 || b.deg == f.degree());
    }
    else{
	polynomial <bigint> x;
	x.assign_x();
	polynomial <bigint> t(x), c, n;
	while (1) {
	    c = t;
	    n = t;
	    for (register lidia_size_t i = d - 1; i; i--){
		n *= n;
		n %= p;
		div_rem(garbage, n, n, f, p);
		c += n;
		c %= p;
	    }
	    b = gcd(f, c, p);
	    if (b.deg == 0 || b.deg == f.degree()){
		t *= x; t *= x;
	    }
	    else break;
	}
    }
    // Apply the algorithm recursively
    if (b.deg == d)
	fa[count++] = b;
    else{
	can_zass(b, fa, d, p, count);
	count += b.deg / d;
    }
    div_rem(b,garbage,f,b,p);
    if (b.deg == d)
	fa[count++] = b;
    else{
	can_zass(b, fa, d, p, count);
	count += b.deg / d;
    }
}

void factor(const base_polynomial <bigint> &f,
	    polynomial < bigint> * fa, lidia_size_t * exponent, const bigint & p)
{
    debug_handler_l("polynomial", "in friend - function factor(...)", -1); 
    polynomial <bigint> * sqf_factor = new polynomial <bigint> [f.degree()+1];
    polynomial <bigint> * ddf_factor = new polynomial <bigint> [f.degree()+1];
    lidia_size_t count = 0;
    register lidia_size_t i = 0;

    for (; i < f.degree(); i++){
	  fa[i].assign_one();
	  exponent[i] = 0;
    }

    squarefree_factor(f, sqf_factor, p);
    debug_handler_l("polynomial", "factor(...)::"
		    "returned from squarefree_factor",-1);

    for (i = 1; i <= f.degree(); i++)
	if (sqf_factor[i].deg != 0 ){
	    if (sqf_factor[i].deg == 1){
		fa[count] = sqf_factor[i];
		exponent[count++] = i;
	    }
	    else{
		ddf(sqf_factor[i], ddf_factor, p);
		debug_handler_l("polynomial", "factor(...)::"
				"returned from ddf",-1);
		// Now call can_zass on each ddf_factor, where necessary.
		for (register lidia_size_t j = 1; j <= sqf_factor[i].deg; j++)
		    if (ddf_factor[j].deg == j){
			fa[count] = ddf_factor[j];
			exponent[count++] = i;
		    }
		    else if (ddf_factor[j].deg != 0){
			can_zass(ddf_factor[j],fa,j,p,count);
			debug_handler_l("polynomial", "factor(...)::"
					"returned from can_zass",-1);
			for (register lidia_size_t k = 0;
			     k < ddf_factor[j].deg /j; k++)
			    exponent[count++]=i;
			debug_handler_l("polynomial", "factor(...)::"
					"stored factors",-1);
		    }
	    }
	}
    delete[] ddf_factor;
    delete[] sqf_factor;
    debug_handler_l("polynomial", "factor(...)::"
		    "freed temporarily allocated space",-1);

}

lidia_size_t no_of_real_roots(const base_polynomial<bigint>& poly_T)
{
  debug_handler_l("polynomial", "no_of_real_roots(...)", -1);
  if (poly_T.degree() == 0 && poly_T[0].is_zero()) { return 0; }
  polynomial<bigint> A=pp(poly_T);
  polynomial<bigint> B=pp(derivation(poly_T));
  lidia_size_t n,s,t,r1,del,te,ll;
  bigint g,h;
  g=1; h=1; n=A.degree(); r1=1;
  s=lead_coeff(A).sign();
  if (n%2==0) { t=-s; }
  else        { t=s;  }

  lidia_size_t degr=1;
  polynomial<bigint> R,Q;
  while (degr!=0)
    { del=A.degree()-B.degree();
      div_rem(Q,R,A,B);
      if (R.degree()==0 && lead_coeff(R)==0)
	{ error_handler("sturm","no_of_real_roots::argument was not square free"); }
      if (lead_coeff(B)>0 || del%2==1) { R=-R; }

      degr=R.degree();
      te=lead_coeff(R).sign();
      if (te!=s)
	{ s=-s;
	  r1=r1-1;
	}      if (degr%2==0) { ll=t; }
      else         { ll=-t; }
      if (te!=ll)
	{ t=-t;
	  r1=r1+1;
	}
      if (degr!=0){
	  A=B;
          bigint bi,bi2;
	  power(bi,h,del);
	  bi=g*bi;
	  B=R/bi;
	  g=abs(lead_coeff(A));
          power(bi2,g,del);
	  power(bi,h,del-1);
	  h=bi2/bi;
	}
    }

  debug_handler_l("polynomial", "end no_of_real_roots(...)", -1);
  return r1;
}
