//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : bigint_def.h 
// Author      : Thomas Papanikolaou (TP)
// Last change : TP, Oct 4 1995, initial version
//

#ifndef LIDIA_BIGINT_DEF_H
#define LIDIA_BIGINT_DEF_H

/**
** The next include MUST remain in this file in THIS position.
**/

#include <LiDIA/lidia.h>

/**
** include here the include file of the C multiple precision integers
** and define integer_type_name to be the integer type we have. Define 
** base_digit to
**
** For example write something like
**
** #include "integer_include_file.h"
** #define integer_type_name  	your_integer_type_name 
**
**/

extern "C" {
#include <LiDIA/lip.h>
};
 
#define integer_type_name     verylong
#define base_digit       unsigned long

#endif
