//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : interface_lib.h 
// Author      : Thomas Papanikolaou (TP)
// Last change : TP, Feb 7 1995, initial version
//

#ifndef LIDIA_INTERFACE_LIB_H
#define LIDIA_INTERFACE_LIB_H

#include <LiDIA/bigint.h>

inline bigint lcm (const bigint & a, const bigint & b)
{ bigint c;  c = gcd(a,b); divide(c, abs(a), c); 
  multiply(c, abs(b), c); return c; }

/* file: fermat.c */
extern int fermat ( const bigint & n );

/* file: integer_log.c */
extern int integer_log ( unsigned long x );

/* file: is_prime.c */
extern int is_prime ( const bigint &a1, const int b1 );

/* file: next_prime.c */
extern bigint next_prime ( const bigint & x );

/* file: jacobi.c */
extern int jacobi ( const bigint &a1, const bigint &b1 );

/* file: nearest.c */
extern void nearest ( bigint & z, const bigint & u, const bigint & v );

/* file: newton_root.c */
extern void newton_root ( bigint & b, const bigint & a, int n );

/* file: power_test.c */
extern int prime_table[];
extern long power_test ( bigint & b, const bigint & a );

/* file: power_mod.c */
extern void power_mod ( bigint & res, const bigint & a, const bigint & n, const bigint & m , int err = 0);

/* file: multiple_gcd.c */
extern bigint * mgcd ( const bigint * a, const int n );

#ifndef HEADBANGER
/* file: single_precision.c */
extern int          gcd ( int a, int b );
extern int          int_xgcd ( int &xv, int &yv, int a, int b );
extern long         xgcd ( long &xv, long &yv, long a, long b );
extern unsigned int power ( unsigned int a, unsigned int b );
extern int          h_mul_mod(int, int, int);
extern int          mul_mod(int, int, int);
extern int          power_mod(int, int, int);
extern int          legendre(int, int);
extern int          invert(int, int);
extern int          jacobi(int, int);
extern int          ressol(int, int);
#endif

#endif
