


#if defined(HAVE_MAC_DIRS) || defined(__MWERKS__)
#include <LiDIA:coeff_sparse_power_serie.h>

#else
#include <LiDIA/coeff_sparse_power_serie.h>
#endif


 //
 //  *****  I/O  *****
 //

 template < class T > 
 void
 spc< T >::
 read ( istream & in )
  {
      debug_handler ( "sparse_powser::spc" , "read" ) ;

      char ch ;

      in >> ch ;
      if ( ch != '[' )
	error_handler ( "sparse_powser::spc" , "read::character ']' expected" ) ;

      in >> this->coeff ;
      in >> this->exp   ;

      in >> ch ;
      if ( ch != ']' )
	error_handler ( "sparse_powser::spc" , "read::character ']' expected" ) ;
  }


 template < class T > 
 void
 spc< T >::
 print (ostream & out) const
  {
      debug_handler ( "sparse_powser::spc" , "print" ) ;
      out << "[ " << this->coeff << " " << this->exp << " ]" ;
  } 


 //
 //  *****  assignment operator   *****
 //

 template < class T >
 const spc< T > & 
 spc< T >::
 operator = ( const spc< T > & c ) 
  {
      debug_handler ( "sparse_powser::spc" , "operator =" ) ;

      coeff = c.coeff ;
      exp   = c.exp   ;

      return *this ;
  }


 //
 //  *****  comparison operators  *****
 //

 template < class T >
 int 
 spc< T >::
 operator < ( const spc< T > & c ) const
  {
      debug_handler ( "sparse_powser::spc" , "operator <" ) ;

      return ( ( exp < c.exp ) ? 1 : 0 ) ;
  }

 template < class T >
 int 
 spc< T >::
 operator <= ( const spc< T > & c ) const
  {
      debug_handler ( "sparse_powser::spc< T >" , "operator <=" ) ;

      return ( ( exp <= c.exp ) ? 1 : 0 ) ;
  }

 template < class T >
 int 
 spc< T >::
 operator == ( const spc< T > & c ) const
  {
      debug_handler ( "sparse_powser::spc" , "operator ==" ) ;

      return ( ( exp == c.exp ) ? 1 : 0 ) ;
  }


 template < class T >
 int
 spc< T >::
 coeff_cmp_zero ( const spc< T > & b ) const
  {
      debug_handler ( "sparse_powser::spc" , "coeff_cmp_zero()" ) ;

      T zero_T = (T) 0 ;
      int rc ;

      // This relation says :  1.) 0 is greater than any other element
      //                       2.) any non-zero elements will be identified
      //
      // Sorting a vector of spcs according to this function will
      // move the zeros into the rear part of the vector


      if ( this->coeff == zero_T && b.coeff == zero_T )
	rc =  0 ;
      else if ( this->coeff == zero_T )
	rc =  1 ;
      else if ( b.coeff == zero_T )
	rc = -1 ;
      else
	rc =  0 ;

      return rc ;
  }


 template < class T >
 void
 spc< T >::
 swap ( spc< T > & b )
  {
    ::swap(coeff,b.coeff);
    ::swap(exp,b.exp);
  }
 
