//
// LiDIA - a library for computational number theory
//   Copyright (c) 1994, 1995 by the LiDIA Group
//
// File        : arith.inl
// Author      : Patrick Theobald (PT)
// Last change : PT, Oct 28 1995, initial version 
//

#ifndef LIDIA_ARITH_INL
#define LIDIA_ARITH_INL

/**
 ** swap
 **/

inline void swap(int &a, int &b)
{int TMP; TMP = a; a = b; b = TMP;}

inline void swap(long &a, long &b)
{long TMP; TMP = a; a = b; b = TMP;}

inline void swap(float &a, float &b)
{float TMP; TMP = a; a = b; b = TMP;}

inline void swap(double &a, double &b)
{double TMP; TMP = a; a = b; b = TMP;}

inline void swap(char &a, char &b)
{char TMP; TMP = a; a = b; b = TMP;}	

/**
 ** addition
 **/ 

inline void add(int &c, int a, int b)
{ c = a + b;}

inline void add(long &c, long a, long b)
{ c = a + b;}

inline void add(float &c, float a, float b)
{ c = a + b;}

inline void add(double &c, double a, double b)
{ c = a + b;}

/** 
 ** subtraction
 **/

inline void subtract(int &c, int a, int b)
{ c = a - b;}

inline void subtract(long &c, long a, long b)
{ c = a - b;}

inline void subtract(float &c, float a, float b)
{ c = a - b;}

inline void subtract(double &c, double a, double b)
{ c = a - b;}

/**
 ** multiplication
 **/

inline void multiply(int &c, int a, int b)
{ c = a * b;}

inline void multiply(long &c, long a, long b)
{ c = a * b;}

inline void multiply(float &c, float a, float b)
{ c = a * b;}

inline void multiply(double &c, double a, double b)
{ c = a * b;}

/**
 ** negation
 **/

inline void negate(int &c, int a)
{ c = -a;}

inline void negate(long &c, long a)
{ c = -a;}

inline void negate(float &c, float a)
{ c = -a;}

inline void negate(double &c, double a)
{ c = -a;}

/** 
 ** divide
 **/

inline void divide(int &c, int a, int b)
{ c = a / b;}

inline void divide(long &c, long a, long b)
{ c = a / b;}

inline void divide(float &c, float a, float b)
{ c = a / b;}

inline void divide(double &c, double a, double b)
{ c = a / b;}

#endif



