//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : pair.h 
// Author      : Thomas Papanikolaou (TP)
// Last change : TP, Feb 7 1995, initial version
//

#ifndef LIDIA_PAIR_H
#define LIDIA_PAIR_H

#include <LiDIA/lidia.h>

template < class T1, class T2 > class pair
{
  T1 l;
  T2 r;

  public:

  pair()
  {
  }

  pair(T1 &pl, T2 &pr)
  {
    l = pl;
    r = pr;
  }

  pair(const pair < T1, T2 > &p)
  {
    l = p.l;
    r = p.r;
  }

  ~pair()
  {
  }


  pair < T1, T2 > operator = (const pair < T1, T2 > &p)
  {
    l = p.l;
    r = p.r;
    return *this;
  }


  T1 & left()
  {
    return l;
  }

  T2 & right()
  {
    return r;
  }

  void read()
  {
    debug_handler("pair", "read()");
    char c = 0;

    cin >> c;
    if (c != '(')
      lidia_error_handler("pair", "read()::( expected");
    else
    {
      cin >> l >> c;
      if (c != ',')
        lidia_error_handler("pair", "read()::, expected");
      cin >> r >> c;
      while (c != ')')
	cin >> c;
    }
  } 
  
  void print() 
  {
    debug_handler("pair", "print()");
    cout << "( " << l << " , " << r << " )";
  }

  friend int compare(const pair < T1, T2 > &p, const pair < T1, T2 > &q)
  {
    int res = 0;
    if (p.l > q.l) res = 1;
    if (p.l < q.l) res = -1;

    if (res == 0)
    {
      if (p.r > q.r) res = 1;
      if (p.r < q.r) res = -1;
    }

    return res;
  }

  int operator == (const pair < T1, T2 > &p)
  {
    int i = (l == p.l) && (r == p.r);
        return i;
  }

  int operator != (const pair < T1, T2 > &p)
  {
    int i = (l != p.l) || (r != p.r);
    return i;
  }

  int operator > (const pair < T1, T2 > &p)
  {
    int i = (l > p.l) || ((l == p.l) && (r > p.r));
    return i;
  }

  int operator >= (const pair < T1, T2 > &p)
  {
    int i = (l >= p.l);
    return i;
  }

  int operator < (const pair < T1, T2 > &p)
  {
    int i = (l < p.l) || ((l == p.l) && (r < p.r));
    return i;
  }

  int operator <= (const pair < T1, T2 > &p)
  {
    int i = (l <= p.l);
    return i;
  }

};

#endif
