#include "kant.h" 
 
main(
)
/*******************************************************************************
 
shovec.c
  
Test program for short vectors in orders
 
JS April 1992
  
*******************************************************************************/
{
	block_declarations;
 
	order		ord;
	t_handle		R;
        lattice         lat;
        lat_enum_env    env;
	integer_small	ub, lb;
        integer_big     norm, den;
        anf_elt         alpha;
 
	kant_start();
 
	while (order_read(&ord))
	{
		order_mult_assure(ord);
                order_reals_create(ord);
                order_lat(ord, &lat, &env);
 
                R = order_reals(ord);

                for(;;)
                {
			printf("Give lower and upper bound:\n");
			scanf("%d %d", &lb, &ub); if (ub < 2) break;
	 
	                lat_enum_request_set_next(env);
			lat_enum_status_set_new(env);
	         	lat_enum_strategy_set_up(env);
	 
	                if (lb) lat_enum_lbound(env) = conv_int_to_real(R, lb);
	                lat_enum_ubound(env) = conv_int_to_real(R, ub);
	 
	                while (lat_enum(lat, env))
	                {
	                     alpha = lat_elt_to_anf_elt(lat, lat_enum_act_coefs(env), ord);
	                     anf_norm(ord, alpha, &norm, &den);
	 
	                     printf("Number: "); anf_elt_write(ord, alpha);
	                     printf(" with norm "); integer_write(norm); puts("");
	 
	                     integer_delref(norm);
	                     integer_delref(den);
	                     anf_elt_delete(ord, &alpha);
	                 }
	
	                 if(lb) real_delete(&lat_enum_lbound(env));
	                 real_delete(&lat_enum_ubound(env));
                 }
 
                 lat_enum_delete(lat, &env);
                 lat_delete(&lat);
                 order_delete(&ord);
	}
}
