/*  withargs.h

Macros for defining and alluding to functions either with or without prototypes,
depending on whether the C compiler to be used accepts them.  To prevent use of
prototypes, define the preprocessor constant DO_NOT_USE_PROTOTYPES.

The WITH_n_ARGs macros are used for function DEFINITIONS (immediately followed
by a code block) and the HAS_n_ARGS for function ALLUSIONS (description of
the calling sequence, without code).  To remember which is WITH and which is
HAS, think of grammatical sentences with the function name as subject: in the
function definition, the predicate is the code block, and WITH_N_ARGS is an
adjectival phrase; in the function allusion, the HAS_n_ARGS part is itself
the predicate, so contains a verb (HAS) rather than a preposition (WITH).
*/

/*  Prevent redefinition in case of multiple inclusion:  */
#ifndef		WITH_1_ARG

#ifdef		DO_NOT_USE_PROTOTYPES

#define WITH_NO_ARG()	()
#define WITH_NO_ARGS()	()

#define WITH_1_ARG( type, name ) \
    ( name ) type name;

#define WITH_2_ARGS( typ1, nam1, typ2, nam2 ) \
    ( nam1, nam2 ) typ1 nam1; typ2 nam2;

#define WITH_3_ARGS( t1, n1, t2, n2, t3, n3 ) \
    ( n1, n2, n3 ) t1 n1; t2 n2; t3 n3;

#define WITH_4_ARGS( t1, n1, t2, n2, t3, n3, t4, n4 ) \
    ( n1, n2, n3, n4 ) t1 n1; t2 n2; t3 n3; t4 n4;

#define WITH_5_ARGS( t1, n1, t2, n2, t3, n3, t4, n4, t5, n5 ) \
    ( n1, n2, n3, n4, n5 ) t1 n1; t2 n2; t3 n3; t4 n4; t5 n5;

#define WITH_6_ARGS( t1, n1, t2, n2, t3, n3, t4, n4, t5, n5, t6, n6 ) \
    ( n1, n2, n3, n4, n5, n6 ) t1 n1; t2 n2; t3 n3; t4 n4; t5 n5; t6 n6;

#define WITH_7_ARGS( t1, n1, t2, n2, t3, n3, t4, n4, t5, n5, t6, n6, t7, n7 ) \
    ( n1, n2, n3, n4, n5, n6, n7 ) \
	t1 n1; t2 n2; t3 n3; t4 n4; t5 n5; t6 n6; t7 n7;

#define WITH_8_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8 ) \
    ( n1, n2, n3, n4, n5, n6, n7, n8 ) \
	t1 n1; t2 n2; t3 n3; t4 n4; t5 n5; t6 n6; t7 n7; t8 n8;

#define WITH_9_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9 ) \
    ( n1, n2, n3, n4, n5, n6, n7, n8, n9 ) \
	t1 n1; t2 n2; t3 n3; t4 n4; t5 n5; t6 n6; t7 n7; t8 n8; t9 n9;

#define WITH_10_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9, t10,n10 ) \
    ( n1, n2, n3, n4, n5, n6, n7, n8, n9, n10 ) \
	t1 n1; t2 n2; t3 n3; t4 n4; t5 n5; t6 n6; t7 n7; t8 n8; t9 n9; t10 n10;

#define WITH_11_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9, t10,n10, t11,n11 ) \
    ( n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11 ) \
	t1 n1; t2 n2; t3 n3; t4 n4; t5 n5; t6 n6; t7 n7; t8 n8; t9 n9; t10 n10; t11 n11;

#define WITH_12_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9, t10,n10, t11,n11, t12,n12 ) \
    ( n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12 ) \
	t1 n1; t2 n2; t3 n3; t4 n4; t5 n5; t6 n6; t7 n7; t8 n8; t9 n9; t10 n10; t11 n11; t12 n12;

#define WITH_13_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9, t10,n10, t11,n11, t12,n12, t13,n13 ) \
    ( n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13 ) \
	t1 n1; t2 n2; t3 n3; t4 n4; t5 n5; t6 n6; t7 n7; t8 n8; t9 n9; t10 n10; t11 n11; t12 n12; t13 n13;

#define WITH_14_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9, t10,n10, t11,n11, t12,n12, t13,n13, t14,n14 ) \
    ( n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14 ) \
	t1 n1; t2 n2; t3 n3; t4 n4; t5 n5; t6 n6; t7 n7; t8 n8; t9 n9; t10 n10; t11 n11; t12 n12; t13 n13; t14 n14;

#define WITH_15_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9, t10,n10, t11,n11, t12,n12, t13,n13, t14,n14, t15,n15 ) \
    ( n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15 ) \
	t1 n1; t2 n2; t3 n3; t4 n4; t5 n5; t6 n6; t7 n7; t8 n8; t9 n9; t10 n10; t11 n11; t12 n12; t13 n13; t14 n14; t15 n15;

/*
For old-style varargs, extra code must be inserted (in an #ifdef conditional
on DO_NOT_USE_PROTOTYPES) to declare and initialize the non-varying arguments
*/

#define WITH_1_OR_MORE_ARGS( t1, n1, dots ) \
    ( va_alist ) \
	va_dcl

#define WITH_2_OR_MORE_ARGS( t1, n1, t2, n2, dots ) \
    ( va_alist ) \
	va_dcl

#define HAS_NO_ARG()	()
#define HAS_NO_ARGS()	()

#define HAS_1_ARG( type, name ) ()
#define HAS_2_ARGS( typ1, nam1, typ2, nam2 ) ()
#define HAS_3_ARGS( t1, n1, t2, n2, t3, n3 ) ()
#define HAS_4_ARGS( t1, n1, t2, n2, t3, n3, t4, n4 ) ()
#define HAS_5_ARGS( t1, n1, t2, n2, t3, n3, t4, n4, t5, n5 ) ()
#define HAS_6_ARGS( t1, n1, t2, n2, t3, n3, t4, n4, t5, n5, t6, n6 ) ()
#define HAS_7_ARGS( t1, n1, t2, n2, t3, n3, t4, n4, t5, n5, t6, n6, t7, n7 ) ()
#define HAS_8_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8 ) ()
#define HAS_9_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9 ) ()
#define HAS_10_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9, t10,n10 ) ()
#define HAS_11_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9, t10,n10, t11,n11 ) ()
#define HAS_12_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9, t10,n10, t11,n11, t12,n12 ) ()
#define HAS_13_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9, t10,n10, t11,n11, t12,n12, t13,n13 ) ()
#define HAS_14_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9, t10,n10, t11,n11, t12,n12, t13,n13, t14,n14 ) ()
#define HAS_15_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9, t10,n10, t11,n11, t12,n12, t13,n13, t14,n14, t15,n15 ) ()

#define HAS_1_OR_MORE_ARGS( t1, n1, dots ) ()
#define HAS_2_OR_MORE_ARGS( t1, n1, t2, n2, dots ) ()

#else		/* Do use prototypes */

#define WITH_NO_ARG()	( void )
#define WITH_NO_ARGS()	( void )

#define WITH_1_ARG( type, name ) \
    ( type name )

#define WITH_2_ARGS( typ1, nam1, typ2, nam2 ) \
    ( typ1 nam1, typ2 nam2 )

#define WITH_3_ARGS( t1, n1, t2, n2, t3, n3 ) \
    ( t1 n1, t2 n2, t3 n3 )

#define WITH_4_ARGS( t1, n1, t2, n2, t3, n3, t4, n4 ) \
    ( t1 n1, t2 n2, t3 n3, t4 n4 )

#define WITH_5_ARGS( t1, n1, t2, n2, t3, n3, t4, n4, t5, n5 ) \
    ( t1 n1, t2 n2, t3 n3, t4 n4, t5 n5 )

#define WITH_6_ARGS( t1, n1, t2, n2, t3, n3, t4, n4, t5, n5, t6, n6 ) \
    ( t1 n1, t2 n2, t3 n3, t4 n4, t5 n5, t6 n6 )

#define WITH_7_ARGS( t1, n1, t2, n2, t3, n3, t4, n4, t5, n5, t6, n6, t7, n7 ) \
    ( t1 n1, t2 n2, t3 n3, t4 n4, t5 n5, t6 n6, t7 n7 )

#define WITH_8_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8 ) \
    ( t1 n1, t2 n2, t3 n3, t4 n4, t5 n5, t6 n6, t7 n7, t8 n8 )

#define WITH_9_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9 ) \
    ( t1 n1, t2 n2, t3 n3, t4 n4, t5 n5, t6 n6, t7 n7, t8 n8, t9 n9 )

#define WITH_10_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9, t10,n10 ) \
    ( t1 n1, t2 n2, t3 n3, t4 n4, t5 n5, t6 n6, t7 n7, t8 n8, t9 n9, t10 n10 )

#define WITH_11_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9, t10,n10, t11,n11 ) \
    ( t1 n1, t2 n2, t3 n3, t4 n4, t5 n5, t6 n6, t7 n7, t8 n8, t9 n9, t10 n10, t11 n11 )

#define WITH_12_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9, t10,n10, t11,n11, t12,n12 ) \
    ( t1 n1, t2 n2, t3 n3, t4 n4, t5 n5, t6 n6, t7 n7, t8 n8, t9 n9, t10 n10, t11 n11, t12 n12 )

#define WITH_13_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9, t10,n10, t11,n11, t12,n12, t13,n13 ) \
    ( t1 n1, t2 n2, t3 n3, t4 n4, t5 n5, t6 n6, t7 n7, t8 n8, t9 n9, t10 n10, t11 n11, t12 n12, t13 n13 )

#define WITH_14_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9, t10,n10, t11,n11, t12,n12, t13,n13, t14,n14 ) \
    ( t1 n1, t2 n2, t3 n3, t4 n4, t5 n5, t6 n6, t7 n7, t8 n8, t9 n9, t10 n10, t11 n11, t12 n12, t13 n13, t14 n14 )

#define WITH_15_ARGS( t1,n1, t2,n2, t3,n3, t4,n4, t5,n5, t6,n6, t7,n7, t8,n8, t9,n9, t10,n10, t11,n11, t12,n12, t13,n13, t14,n14, t15,n15 ) \
    ( t1 n1, t2 n2, t3 n3, t4 n4, t5 n5, t6 n6, t7 n7, t8 n8, t9 n9, t10 n10, t11 n11, t12 n12, t13 n13, t14 n14, t15 n15 )

#define WITH_1_OR_MORE_ARGS( t1, n1, dots ) \
    ( t1 n1, ... )

#define WITH_2_OR_MORE_ARGS( t1, n1, t2, n2, dots ) \
    ( t1 n1, t2 n2, ... )

#define HAS_NO_ARG	WITH_NO_ARG
#define HAS_NO_ARGS	WITH_NO_ARGS
#define HAS_1_ARG	WITH_1_ARG
#define HAS_2_ARGS	WITH_2_ARGS
#define HAS_3_ARGS	WITH_3_ARGS
#define HAS_4_ARGS	WITH_4_ARGS
#define HAS_5_ARGS	WITH_5_ARGS
#define HAS_6_ARGS	WITH_6_ARGS
#define HAS_7_ARGS	WITH_7_ARGS
#define HAS_8_ARGS	WITH_8_ARGS
#define HAS_9_ARGS	WITH_9_ARGS
#define HAS_10_ARGS	WITH_10_ARGS
#define HAS_11_ARGS	WITH_11_ARGS
#define HAS_12_ARGS	WITH_12_ARGS
#define HAS_13_ARGS	WITH_13_ARGS
#define HAS_14_ARGS	WITH_14_ARGS
#define HAS_15_ARGS	WITH_15_ARGS

#define HAS_1_OR_MORE_ARGS	WITH_1_OR_MORE_ARGS
#define HAS_2_OR_MORE_ARGS	WITH_2_OR_MORE_ARGS

#endif		/* DO_[NOT]_USE_PROTOTYPES */

#endif		/* WITH_1_ARG */
