#ifndef	_RING_H_
#define _RING_H_

/*
** ring.h
** Define common types and constants for rings and fields.
*/

#include "defs.h"
#include "att.h"
#include "integer.e"
#include "ring.e"
#include "gen_ring.h"

#define ring_delref	ring_delete

#define m_ring_incref	block_incref


/*
** The total and the indices in which the flags are stored.
** Flags are stored in ternary form.
*/

typedef enum {
	RING_ATT_ED,
	RING_ATT_FIELD,
	RING_ATT_PACKED,
	RING_ATT_QUOTIENT,
	RING_ATT_TOTAL
	} ring_att_numbers;


/*
** the generic ring structure.
*/

typedef struct
	{
		t_structure_hdr	rg_structure;

		integer_small	rg_type;
		int		rg_known[ att_req_length(RING_ATT_TOTAL) ];
		int		rg_value[ att_req_length(RING_ATT_TOTAL) ];
		void		*ring_matp_primitives;
		void		*ring_matp_tables_p;
		t_handle	ring_matp_tables_h;
		t_handle	ideal;
		t_handle	free_ring; /* If it is a quotient ring, this is 
					   ** the top ring.
					   */
		t_handle	gring_blk; /* Block for caching ring fns. */
		t_grf		gring_ptr;
	}
	t_ring_common;

/*
** Access the ring structure and the specific structure through blockhandler.
*/

#define ring_access(h) ((t_ring_common *) mem_access(h))


/*
** generic ring macros
*/

#define m_ring_type(h)		(ring_access(h) -> rg_type)
#define m_ring_ideal(h)		(ring_access(h) -> ideal)
#define m_ring_free_ring(h)	(ring_access(h) -> free_ring)

/*
**
** HACK for v3 compatability
**
*/


extern t_pfh ring_addition P_((t_handle));
extern t_pfh ring_comparison P_((t_handle));
extern t_pfh ring_equality P_((t_handle));
extern t_pfh ring_exponentiation P_((t_handle));
extern t_pfh ring_inversion P_((t_handle));
extern t_pfh ring_minus_one_test P_((t_handle));
extern t_pfh ring_multiplication P_((t_handle));
extern t_pfh ring_negation P_((t_handle));
extern t_pfh ring_one_test P_((t_handle));
extern t_pfh ring_slash_op P_((t_handle));
extern t_pfh ring_subtraction P_((t_handle));
extern t_pfh ring_zero_test P_((t_handle));

#define ring_add(h, a, b)	((* ring_addition(h))(h, a, b))
#define ring_mult(h, a, b)	((* ring_multiplication(h))(h, a, b))
#define ring_negate(h, a)	((* ring_negation(h))(h, a))
#define ring_inverse(h, a)	((* ring_inversion(h))(h, a))
#define ring_subtract(h, a, b)	((* ring_subtraction(h))(h, a, b))
#define ring_power(h, a, b)	((* ring_exponentiation(h))(h, a, b))
#define ring_elt_equal(h, a, b)	((* ring_equality(h)) (h, a, b))
#define ring_elt_compare(h, a, b)	((* ring_comparison(h)) (h, a, b))
#define ring_is_one(h, a)	((* ring_one_test(h))(h, a))
#define ring_is_zero(h, a)	((* ring_zero_test(h))(h, a))
#define ring_is_minus_one(h, a)	((* ring_minus_one_test(h))(h, a))
#define ring_is_minus1 ring_is_minus_one



/*
** macros to access and set the flag values stored in the header.
** flags are stored in ternary (don't know, true, false) values.
*/

#define ring_known(h)		(ring_access(h) -> rg_known)
#define ring_value(h)		(ring_access(h) -> rg_value)

/*
** access to the macros.
** some do not define a "is it definitely false" if this is never needed.
*/

#define m_ring_is_field(h) \
    att3_is_true(ring_known(h), ring_value(h), RING_ATT_FIELD)

#define m_ring_is_ed(h) \
    att3_is_true(ring_known(h), ring_value(h), RING_ATT_ED)

#define m_ring_is_packed(h) \
    att2_is_true(ring_value(h), RING_ATT_PACKED)

#define m_ring_is_quotient(h) \
    att3_is_true(ring_known(h), ring_value(h), RING_ATT_QUOTIENT)
/*
** set values for flags, moving them from the (don't know) to a known value
*/

#define m_ring_set_is_ed_true(h) \
    att3_set_true(ring_known(h), ring_value(h), RING_ATT_ED)

#define m_ring_set_is_ed_false(h) \
    att3_set_false(ring_known(h), ring_value(h), RING_ATT_ED)

#define m_ring_set_is_field_true(h) \
    att3_set_true(ring_known(h), ring_value(h), RING_ATT_FIELD)

#define m_ring_set_is_field_false(h) \
    att3_set_false(ring_known(h), ring_value(h), RING_ATT_FIELD)

#define m_ring_set_packed_true(h) \
    att3_set_true(ring_known(h), ring_value(h), RING_ATT_PACKED)

#define m_ring_set_is_quotient_true(h) \
    att3_set_true(ring_known(h), ring_value(h), RING_ATT_QUOTIENT)

#define m_ring_set_is_quotient_false(h) \
    att3_set_false(ring_known(h), ring_value(h), RING_ATT_QUOTIENT)

#define ring_minus1 ring_minus_one




/*
** lifting and common structure code
*/

/*
** find the common structure for the two arguments.
*/

#define ring_coerce_str( str1, str2, pstr ) \
		ring_over_str( str1, str2, pstr )

/*
** As above, but lift elements as well.
*/

#define ring_coerce_str_lift1( str1, elt1, nelt1, str2, pstr ) \
		ring_coerce( str1, elt1, nelt1, str2, 0, 0, pstr )

#define ring_coerce_str_lift2( str1, elt1, nelt1, str2, elt2, nelt2, pstr ) \
		ring_coerce( str1, elt1, nelt1, str2, elt2, nelt2, pstr )


#if 0
/*
** Hack to allow z ring stuff to work. Too much old code using the
** ring_bound() macro.
*/

#include "z.e"
#endif /* 0 */


#endif	/* _RING_H_ */
