
/*  principal_ideal.e
Package for principal ideals.
*/

#ifndef	_PI_E
#define	_PI_E

#include "defs.h"
#include "gen_ring.h"

/*
** Structure of the block containing a principal ideal
*/

typedef struct
	{
		t_structure_hdr pi_structure;
		t_handle	ring;
		t_handle	generator;
		faclst		factors;
	}
	t_pi_table;

#define ideal_incref(i)		block_incref(i)
/*
** Access to the information in the ring block.
*/

#define m_pi_access(h)		((t_pi_table *) mem_access(h))
#define m_pi_ring(h)		(m_pi_access(h) -> ring)
#define m_pi_generator(h)	(m_pi_access(h) -> generator)
#define m_pi_factors(h)		(m_pi_access(h) -> factors)

/* pi refcounts. */

#define m_pi_str_incref(r)		(block_incref(r))
#define m_pi_str_delete(r)		principal_ideal_str_delete(0,&r)

/* The context */
typedef struct
{
	t_handle	ring;
	t_handle	generator;
	t_grf		gprim_fns;
} t_pi_context;

typedef	    t_pi_context	*t_pi_ctx;

/* Now for context access functions. */
#define m_gen_pi_prms(ctx)		(ctx->gprim_fns)
#define m_pi_ctx_elt_add(c)	(m_gringp_elt_add(m_gen_pi_prms(c)))
#define m_pi_ctx_elt_coerce(c)	(m_gringp_elt_coerce(m_gen_pi_prms(c)))
#define m_pi_ctx_elt_delete(c)	(m_gringp_elt_delete(m_gen_pi_prms(c)))
#define m_pi_ctx_elt_equal(c)	(m_gringp_elt_equal(m_gen_pi_prms(c)))
#define m_pi_ctx_elt_gcd(c)	(m_gringp_elt_gcd(m_gen_pi_prms(c)))
#define m_pi_ctx_elt_incref(c)	(m_gringp_elt_incref(m_gen_pi_prms(c)))
#define m_pi_ctx_elt_mult(c)	(m_gringp_elt_mult(m_gen_pi_prms(c)))
#define m_pi_ctx_elt_negate(c)	(m_gringp_elt_negate(m_gen_pi_prms(c)))
#define m_pi_ctx_elt_power(c)	(m_gringp_elt_power(m_gen_pi_prms(c)))
#define m_pi_ctx_elt_print(c)	(m_gringp_elt_print(m_gen_pi_prms(c)))
#define m_pi_ctx_elt_quotrem(c)	(m_gringp_elt_quotrem(m_gen_pi_prms(c)))
#define m_pi_ctx_elt_subtract(c)	(m_gringp_elt_subtract(m_gen_pi_prms(c)))
#define m_pi_ctx_is_zero(c)	(m_gringp_is_zero(m_gen_pi_prms(c)))

#define	m_pi_ctx_ring(c)	(c->ring) 
#define	m_pi_ctx_generator(c)	(c->generator) 

/* Protos */

extern t_logical glue_principal_ideal_is_subsetq P_((t_handle, t_handle));
extern t_logical principal_ideal_is_subideal P_((t_handle, t_handle));
extern t_logical principal_ideal_is_member P_((t_handle, t_handle, t_pi_elt));
extern t_logical glue_principal_ideal_is_member P_((t_handle, t_handle, t_handle, t_handle));
extern t_handle glue_principal_ideal_add P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_principal_ideal_eq P_((t_handle,t_handle,t_handle,t_handle,t_handle,t_handle));
extern t_handle glue_principal_ideal_mult P_((t_handle,t_handle,t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_principal_ideal_negate P_((t_handle,t_handle,t_handle *));
extern t_handle glue_principal_ideal_power P_((t_handle,t_handle,t_handle,t_handle,t_handle*,t_handle*,t_handle *));
extern t_handle glue_principal_ideal_scalar_mult P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_principal_ideal_str_add P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_principal_ideal_str_div P_((t_handle,t_handle,t_handle));
extern t_handle glue_principal_ideal_str_eq P_((t_handle,t_handle,t_handle,t_handle,t_handle,t_handle));
extern t_handle glue_principal_ideal_str_meet P_((t_handle,t_handle));
extern t_handle glue_principal_ideal_str_mult P_((t_handle,t_handle,t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_principal_ideal_str_scalar_mult P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_principal_ideal_subtract P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle pi_str_add_ctx P_((t_pi_ctx,t_handle,t_handle));
extern t_handle pi_str_div_ctx P_((t_pi_ctx,t_handle,t_handle));
extern t_handle pi_str_meet_ctx P_((t_pi_ctx,t_handle,t_handle));
extern t_handle pi_str_mult_ctx P_((t_pi_ctx,t_handle,t_handle));
extern t_handle pi_str_scalar_mult_ctx P_((t_pi_ctx,t_handle,t_handle));
extern t_handle principal_ideal_str_add P_((t_handle,t_handle));
extern t_handle principal_ideal_str_create P_((t_handle,t_handle));
extern t_handle principal_ideal_str_div P_((t_handle,t_handle));
extern t_handle principal_ideal_str_incref P_((t_handle,t_handle));
extern t_handle principal_ideal_str_meet P_((t_handle,t_handle));
extern t_handle principal_ideal_str_mult P_((t_handle,t_handle));
extern t_handle principal_ideal_str_scalar_mult P_((t_handle,t_handle));
extern t_logical pi_elt_coerce_ctx P_((t_pi_ctx,t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_logical principal_ideal_elt_coerce P_((t_handle,t_handle,t_handle,t_handle,t_handle*,t_handle*,t_logical));
extern t_logical principal_ideal_elt_iterator_next P_((t_handle,t_handle*,t_handle*,t_handle*,t_int *));
extern t_logical principal_ideal_str_coerce P_((t_handle,t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_logical principal_ideal_str_iterator_next P_((t_handle,t_handle*,t_handle*,t_handle*,t_int *));
extern t_pi_elt pi_elt_add_ctx P_((t_pi_ctx,t_pi_elt,t_pi_elt));
extern t_pi_elt pi_elt_equal_ctx P_((t_pi_ctx,t_pi_elt,t_pi_elt));
extern t_pi_elt pi_elt_incref_ctx P_((t_pi_ctx,t_pi_elt));
extern t_pi_elt pi_elt_mult_ctx P_((t_pi_ctx,t_pi_elt,t_pi_elt));
extern t_pi_elt pi_elt_negate_ctx P_((t_pi_ctx,t_pi_elt));
extern t_pi_elt pi_elt_power_ctx P_((t_pi_ctx,t_pi_elt,t_int));
extern t_pi_elt pi_elt_subtract_ctx P_((t_pi_ctx,t_pi_elt,t_pi_elt));
extern t_logical pi_str_equal_ctx P_((t_pi_ctx,t_handle,t_handle));
extern t_pi_elt principal_ideal_elt_add P_((t_handle,t_pi_elt,t_pi_elt));
extern t_pi_elt principal_ideal_elt_equal P_((t_handle,t_pi_elt,t_pi_elt));
extern t_pi_elt principal_ideal_elt_incref P_((t_handle,t_pi_elt));
extern t_pi_elt principal_ideal_elt_mult P_((t_handle,t_pi_elt,t_pi_elt));
extern t_pi_elt principal_ideal_elt_negate P_((t_handle,t_pi_elt));
extern t_pi_elt principal_ideal_elt_power P_((t_handle,t_pi_elt,t_int));
extern t_pi_elt principal_ideal_elt_scalar_mult P_((t_handle,t_pi_elt,t_handle));
extern t_pi_elt principal_ideal_elt_subtract P_((t_handle,t_pi_elt,t_pi_elt));
extern t_logical principal_ideal_str_equal P_((t_handle,t_handle));
extern t_logical ideal_is_equal P_((t_handle,t_handle));
extern t_void init_gprim_fns P_((t_handle,t_grf));
extern t_void pi_ctx_init P_((t_handle,t_pi_ctx));
extern t_void pi_elt_delete_ctx P_((t_pi_ctx,t_handle *));
extern t_void pi_elt_print_ctx P_((t_pi_ctx,t_handle,t_int,t_int));
extern t_void principal_ideal_elt_delete P_((t_handle,t_handle *));
extern t_void principal_ideal_elt_iterator_ctx P_((t_handle,t_logical,t_handle *));
extern t_void principal_ideal_elt_print P_((t_handle,t_handle,t_int,t_int));
extern t_void principal_ideal_str_delete P_((t_handle,t_handle *));
extern t_void principal_ideal_str_iterator_ctx P_((t_handle,t_logical,t_handle *));
extern t_void principal_ideal_str_print P_((t_handle,t_handle,t_int,t_int));
extern t_pi_elt pi_elt_scalar_mult_ctx P_((t_pi_ctx, t_pi_elt, t_handle));

#endif	/* _PI_E */
