#ifndef _POLY_E_
#define _POLY_E_

#include "defs.h"
#include "gen_ring.h"

/*
** Definitions of the public interface for the polynomial object
*/

typedef struct
{
        /* Context information. */
        t_handle        cring;
        t_logical       quotient;
        t_handle        ideal;
 
        /* Generic ring fns. */
        t_grf     gprim_fns;
} t_poly_context;

typedef     t_poly_context    *t_poly_ctx;

#define poly_declarations   t_poly_context    cring_fns

/* This is to be used for routines which call init_cring_fns. This
** way, the whole structure is put on the runtime stack when needed.
*/
/* Note that the access macros are in poly.h */

/*
** Prototype inclusion.
*/


/* poly module protos */

extern t_poly glue_poly_reduce P_((t_handle, t_handle));
extern t_poly poly_reduce P_((t_handle, t_poly));
extern t_poly poly_reduce_crf P_((t_poly_ctx, t_poly));
extern t_handle	glue_poly_quotient_ring P_((t_handle, t_handle, t_handle));
extern t_poly poly_lcm P_((t_handle, t_poly, t_poly));
extern t_poly poly_lcm_crf P_((t_poly_ctx, t_poly, t_poly));
extern dyn_arr_handle poly_degree_n_vector P_((t_poly,t_int));
extern dyn_arr_handle poly_degree_vector P_((t_poly));
extern t_handle poly_coeff_ring P_((t_handle));
extern t_handle poly_nvars P_((t_handle));
extern t_logical poly_is_univariate P_((t_poly));
extern t_logical poly_eq P_((t_handle, t_poly, t_poly));
extern t_logical poly_eq_crf P_((t_poly_ctx, t_poly, t_poly));
extern t_poly poly_add P_((t_handle,t_poly,t_poly));
extern t_poly poly_add_crf P_((t_poly_ctx,t_poly,t_poly));
extern t_poly poly_array_get P_((t_handle,t_int));
extern t_poly poly_clean P_((t_handle,t_poly));
extern t_poly poly_clean_crf P_((t_poly_ctx,t_poly));
extern t_poly poly_deriv_princvar P_((t_handle,t_poly));
extern t_poly poly_deriv_princvar_crf P_((t_poly_ctx,t_poly));
extern t_poly poly_constant_dims P_((t_handle,t_int,t_int,t_handle));
extern t_poly poly_constant_dims_crf P_((t_poly_ctx,t_int,t_int,t_handle));
extern t_poly poly_constant_poly P_((t_handle,t_poly,t_handle));
extern t_poly poly_constant_poly_crf P_((t_poly_ctx,t_poly,t_handle));
extern t_poly poly_copy_poly P_((t_handle,t_poly));
extern t_poly poly_copy_poly_crf P_((t_poly_ctx,t_poly));
extern t_poly poly_elt_incref P_((t_handle,t_poly));
extern t_poly poly_elt_incref_crf P_((t_poly_ctx,t_poly));
extern t_logical poly_empty P_((t_poly));
extern t_poly poly_evaluate P_((t_handle, t_poly, t_int, t_handle));
extern t_poly poly_evaluate_crf P_((t_poly_ctx, t_poly, t_int, t_handle));
extern t_poly poly_eval_princvar P_((t_handle, t_poly, t_int));
extern t_poly poly_eval_princvar_crf P_((t_poly_ctx, t_poly, t_int));
extern t_poly poly_high_deriv_ith_var P_((t_handle,t_poly, t_int, t_int));
extern t_poly poly_high_deriv_ith_var_crf P_((t_poly_ctx,t_poly, t_int, t_int));
extern t_poly poly_high_deriv_princvar P_((t_handle,t_poly, t_int));
extern t_poly poly_high_deriv_princvar_crf P_((t_poly_ctx,t_poly, t_int));
extern t_logical glue_poly_is_zero P_((t_handle, t_poly));
extern t_logical poly_is_zero P_((t_handle, t_poly));
extern t_logical poly_is_zero_crf P_((t_poly_ctx, t_poly));
extern t_logical glue_poly_is_one P_((t_handle, t_poly));
extern t_logical poly_is_one P_((t_handle, t_poly));
extern t_logical poly_is_one_crf P_((t_poly_ctx, t_poly));
extern t_logical glue_poly_is_minus_one P_((t_handle, t_poly));
extern t_logical poly_is_minus_one P_((t_handle, t_poly));
extern t_logical poly_is_minus_one_crf P_((t_poly_ctx, t_poly));
extern t_poly poly_ith_coefft P_((t_handle,t_poly,t_int));
extern t_poly poly_ith_coefft_crf P_((t_poly_ctx,t_poly,t_int));
extern t_poly poly_ithvar_deriv P_((t_handle,t_poly,t_int));
extern t_poly poly_ithvar_deriv_crf P_((t_poly_ctx,t_poly,t_int));
extern t_poly poly_lead_coefft P_((t_handle,t_poly));
extern t_poly poly_lead_coefft_crf P_((t_poly_ctx,t_poly));
extern t_poly poly_mult P_((t_handle,t_poly,t_poly));
extern t_poly poly_mult_crf P_((t_poly_ctx,t_poly,t_poly));
extern t_poly poly_negate P_((t_handle,t_poly));
extern t_poly poly_negate_crf P_((t_poly_ctx,t_poly));
extern t_poly poly_power P_((t_handle,t_poly,t_int));
extern t_poly poly_power_crf P_((t_poly_ctx,t_poly,t_int));
extern t_void poly_quot_rem P_((t_handle,t_poly,t_poly, t_poly *, t_poly *));
extern t_void poly_quot_rem_crf P_((t_poly_ctx,t_poly,t_poly,t_poly *, t_poly *));
extern t_poly poly_reductum P_((t_handle,t_poly));
extern t_poly poly_reductum_crf P_((t_poly_ctx,t_poly));
extern t_poly poly_scalar_add P_((t_handle,t_poly,t_handle));
extern t_poly poly_scalar_add_crf P_((t_poly_ctx,t_poly,t_handle));
extern t_poly poly_scalar_mult P_((t_handle,t_poly,t_handle));
extern t_poly poly_scalar_mult_crf P_((t_poly_ctx,t_poly,t_handle));
extern t_poly poly_subtract P_((t_handle,t_poly,t_poly));
extern t_poly poly_subtract_crf P_((t_poly_ctx,t_poly,t_poly));
extern t_poly poly_trailing_coefft P_((t_handle,t_poly));
extern t_poly poly_trailing_coefft_crf P_((t_poly_ctx,t_poly));
extern t_void poly_xgcd P_((t_handle,t_poly,t_poly,t_poly *,t_poly *,t_poly *,t_poly *,t_poly *));
extern t_void poly_xgcd_crf P_((t_poly_ctx,t_poly,t_poly,t_poly *,t_poly *,t_poly *,t_poly *,t_poly *));
extern t_poly poly_zero_poly P_((t_handle,t_poly));
extern t_poly poly_zero_poly_crf P_((t_poly_ctx,t_poly));
extern t_handle poly_z_embed_crf P_((t_poly_ctx,integer_big));
extern t_bit_vector bit_vector_AND P_((t_bit_vector,t_bit_vector));
extern t_bit_vector bit_vector_OR P_((t_bit_vector,t_bit_vector));
extern t_bit_vector bit_vector_shift_left P_((t_bit_vector,t_int));
extern t_bit_vector partition_to_set P_((t_handle));
extern t_handle glue_poly_derivative_ithvar P_((t_handle, t_handle, t_handle, t_handle));
extern t_handle glue_poly_derivative P_((t_handle, t_handle, t_handle));
extern t_handle glue_poly_add P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_poly_coefficients P_((t_handle,t_handle));
extern t_handle glue_poly_coefft P_((t_handle,t_handle,t_handle, t_handle *, t_handle *));
extern t_handle glue_poly_degree P_((t_handle,t_handle));
extern t_handle glue_poly_eq P_((t_handle,t_handle,t_handle,t_handle,t_handle,t_handle));
extern t_handle glue_poly_leading_base_coefft P_((t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_poly_leading_coefft P_((t_handle,t_handle, t_handle *, t_handle *));
extern t_handle glue_poly_leading_term P_((t_handle,t_poly));
extern t_handle glue_poly_left_scalar_mult P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_poly_monomial_coefft P_((t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_poly_mult P_((t_handle,t_handle,t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_poly_negate P_((t_handle,t_handle,t_handle *));
extern t_handle glue_poly_power P_((t_handle,t_handle,t_handle,t_handle,t_handle*,t_handle*,t_handle *));
extern t_handle glue_poly_reductum P_((t_handle,t_handle));
extern t_handle glue_poly_scalar_add P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_poly_subtract P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_poly_total_degree P_((t_handle,t_handle));
extern t_handle glue_poly_trailing_base_coefft P_((t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_poly_trailing_coefft P_((t_handle,t_handle,t_handle *, t_handle *));
extern t_handle glue_poly_trailing_degree P_((t_handle,t_handle));
extern t_handle glue_poly_trailing_term P_((t_handle,t_poly));
extern t_handle glue_poly_trailing_total_degree P_((t_handle,t_handle));
extern t_handle poly_array_alloc P_((t_int));
extern t_handle poly_discriminant P_((t_handle,t_poly));
extern t_handle poly_ith_ring P_((t_handle,t_int));
extern t_handle poly_ith_var P_((t_handle,t_int));
extern t_handle poly_lbase_coefft P_((t_handle,t_poly));
extern t_handle poly_lbase_coefft_crf P_((t_poly_ctx, t_poly));
extern t_handle poly_monomial_coefft P_((t_handle,t_poly,t_poly));
extern t_handle poly_monomial_coefft_crf P_((t_poly_ctx,t_poly,t_poly));
extern t_handle poly_str_create P_((t_handle,t_int));
extern t_handle poly_quo_str_create P_((t_handle,t_handle));
extern t_handle poly_str_incref P_((t_handle,t_handle));
extern t_handle poly_tbase_coefft P_((t_handle,t_poly));
extern t_handle poly_tbase_coefft_crf P_((t_poly_ctx,t_poly));
extern t_int poly_array_length P_((t_handle));
extern t_int poly_deg P_((t_poly));
extern t_int poly_deg_sp_var P_((t_poly,t_int));
extern t_int poly_total_degree P_((t_poly));
extern t_int poly_trailing_degree P_((t_poly));
extern t_int poly_trailing_total_degree P_((t_poly));
extern t_int poly_varnum P_((t_poly));
extern t_logical bit_vector_equal P_((t_bit_vector,t_bit_vector));
extern t_logical bit_vector_subset P_((t_bit_vector,t_bit_vector));
extern t_logical bv_is_set P_((t_bit_vector,t_int));

extern t_logical poly_is_monomial P_((t_poly));
extern t_matrix poly_mat_mult P_((t_matrix,t_matrix,t_int));
extern t_void bit_vector_delete P_((t_bit_vector *));
extern t_void bit_vector_print P_((t_bit_vector));
extern t_void bv_bit_set P_((t_bit_vector,t_int));
extern t_handle glue_poly_ith_ring P_((t_handle,t_handle,t_int,t_handle*,t_handle*,t_int *));
extern t_handle glue_poly_ith_var P_((t_handle,t_int,t_handle*,t_handle*,t_int *));
extern t_void poly_array_append P_((t_handle,t_poly));
extern t_void poly_array_delete P_((t_handle,t_handle *));
extern t_void poly_array_permute P_((t_handle));
extern t_void poly_array_write P_((t_handle,t_handle));
extern t_void poly_create_empty P_((t_handle*,t_int,t_int,t_int));
extern t_void poly_delref_crf P_((t_poly_ctx,t_poly));
extern t_void poly_elt_delete P_((t_handle,t_poly *));
extern t_void poly_elt_delete_crf P_((t_poly_ctx,t_poly *));
extern t_void poly_elt_print P_((t_handle,t_poly));
extern t_void poly_elt_print_crf P_((t_poly_ctx,t_handle, t_poly));
extern t_void poly_init_context P_((t_handle,t_poly_ctx));
extern t_void poly_mat_delete P_((t_matrix));
extern t_void poly_minspace P_((t_handle,t_int));
extern t_void poly_str_delete P_((t_handle,t_handle *));
extern t_void poly_str_print P_((t_handle,t_handle));
extern t_handle glue_poly_gcd P_((t_handle, t_handle, t_handle));

/* poly_z module protos */

extern integer_big poly_z_const_chin_rem P_((integer_big,t_int,t_int,integer_big,t_int));
extern integer_big poly_z_const_term P_((t_poly));
extern integer_big poly_z_integer_cont_sub P_((t_handle,t_poly,integer_big));
extern integer_big poly_z_integer_content P_((t_handle,t_poly));
extern integer_big poly_z_max_norm P_((t_handle,t_poly));
extern integer_big poly_z_sum_norm P_((t_handle,t_poly));
extern t_poly poly_z_abs P_((t_handle,t_poly));
extern t_poly poly_z_add P_((t_handle,t_poly,t_poly));
extern t_poly poly_z_chinese_rem P_((t_handle,integer_big,t_int,t_int,t_poly,t_poly));
extern t_poly poly_z_clean P_((t_handle,t_poly));
extern t_poly poly_z_constant_dims P_((t_handle,t_int,t_int,integer_big));
extern t_poly poly_z_constant_poly P_((t_handle,t_poly,integer_big));
extern t_poly poly_z_copy_poly P_((t_handle,t_poly));
extern t_poly poly_z_deriv_princvar P_((t_handle,t_poly));
extern t_poly poly_z_div P_((t_handle,t_poly,t_poly));
extern t_poly poly_z_elt_incref P_((t_handle,t_poly));
extern t_poly poly_z_eval_princvar P_((t_handle,t_poly,integer_big));
extern t_poly poly_z_evaluate P_((t_handle,t_poly,t_int,integer_big));
extern t_poly poly_z_exp P_((t_handle,t_poly,t_int));
extern t_poly poly_z_gcd P_((t_handle,t_poly,t_poly));
extern t_poly poly_z_high_deriv_ith_var P_((t_handle,t_poly,t_int,t_int));
extern t_poly poly_z_high_deriv_princvar P_((t_handle,t_poly,t_int));
extern t_poly poly_z_integer_add P_((t_handle,t_poly,t_int));
extern t_poly poly_z_integer_div P_((t_handle,t_poly,integer_big));
extern t_poly poly_z_integer_mult P_((t_handle,t_poly,integer_big));
extern t_poly poly_z_ith_deriv P_((t_handle,t_poly,t_int));
extern t_poly poly_z_lbase_coefft P_((t_handle,t_poly));
extern t_poly poly_z_lead_coefft P_((t_handle,t_poly));
extern t_poly poly_z_lead_coefft_crf P_((t_poly_ctx,t_poly));
extern t_poly poly_z_lead_coefft_svar P_((t_handle,t_poly,t_int));
extern t_poly poly_z_mult P_((t_handle,t_poly,t_poly));
extern t_poly poly_z_negate P_((t_handle,t_poly));
extern t_poly poly_z_printable_poly P_((t_handle,t_poly));
extern t_poly poly_z_random P_((t_handle,t_int,integer_big));
extern t_poly poly_z_random_rec P_((t_handle,t_int,t_int,t_int,integer_big));
extern t_poly poly_z_reductum P_((t_handle,t_poly));
extern t_poly poly_z_resultant P_((t_handle,t_poly,t_poly));
extern t_poly poly_z_resultant_top P_((t_handle,t_poly,t_poly));
extern t_poly poly_z_shift_range P_((t_handle,t_poly,integer_big));
extern t_poly poly_z_subtract P_((t_handle,t_poly,t_poly));
extern t_poly poly_z_x P_((t_handle,t_poly));
extern t_poly poly_z_zero_poly P_((t_handle,t_poly));
extern t_handle glue_poly_z_abs P_((t_handle,t_handle));
extern t_handle glue_poly_z_add P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_poly_z_content P_((t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_poly_z_contpp P_((t_handle,t_handle,t_handle*,t_handle*,t_handle *));
extern t_handle glue_poly_z_derivative P_((t_handle,t_handle,t_handle));
extern t_handle glue_poly_z_derivative_ithvar P_((t_handle,t_handle,t_handle,t_handle));
extern t_handle glue_poly_z_discriminant P_((t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_poly_z_div P_((t_handle,t_handle,t_handle));
extern t_handle glue_poly_z_eq P_((t_handle,t_handle,t_int,t_handle,t_handle,t_int));
extern t_handle glue_poly_z_evaluate P_((t_handle,t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_poly_z_exp P_((t_handle,t_handle,t_int,t_int,t_handle*,t_handle*,t_int *));
extern t_handle glue_poly_z_gcd P_((t_handle,t_handle,t_handle));
extern t_handle glue_poly_z_left_scalar_mult P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_poly_z_max_norm P_((t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_poly_z_mod P_((t_handle,t_handle,t_handle));
extern t_handle glue_poly_z_mult P_((t_handle,t_handle,t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_poly_z_negate P_((t_handle,t_handle,t_handle *));
extern t_handle glue_poly_z_pfactorisation P_((t_handle,t_handle,t_handle,t_handle*,t_handle*));
extern t_handle glue_poly_z_primitive_part P_((t_handle,t_handle));
extern t_handle glue_poly_z_quotrem P_((t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_poly_z_random_bnd P_((t_handle,t_handle,t_handle));
extern t_handle glue_poly_z_resultant P_((t_handle,t_handle,t_handle));
extern t_handle glue_poly_z_scalar_add P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_poly_z_scalar_div P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_poly_z_sign P_((t_handle,t_handle));
extern t_handle glue_poly_z_sqfree_factorization P_((t_handle,t_handle));
extern t_handle glue_poly_z_subtract P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_poly_z_sum_norm P_((t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_poly_z_xgcd P_((t_handle,t_handle,t_handle,t_handle*,t_handle*,t_handle *));
extern t_handle poly_z_discriminant P_((t_handle,t_poly));
extern t_handle poly_z_farray_to_feseq P_((t_handle,t_int,t_integer,t_handle));
extern t_void	poly_z_farray_add_content P_((t_handle,t_int,t_integer,t_handle));
extern t_handle poly_z_lift_rec P_((t_handle,t_handle,t_handle));
extern t_handle poly_z_sqf_factorize P_((t_handle,t_poly));
extern t_handle poly_z_square_free P_((t_handle,t_poly));
extern t_int poly_z_clean_rec P_((t_handle,t_poly));
extern t_int poly_z_factor_coef_bound P_((t_handle));
extern t_int poly_z_sign P_((t_handle,t_poly));
extern t_logical poly_z_different P_((t_handle,t_poly,t_poly));

extern t_logical poly_z_is_one_poly P_((t_handle,t_poly));
extern t_logical poly_z_is_zero_poly P_((t_handle,t_poly));
extern t_void poly_z_Qmatrix_write P_((t_handle));
extern t_void poly_z_advance2 P_((t_handle,t_poly,t_int*,t_poly*,t_poly *));
extern t_void poly_z_calc_write P_((t_handle,t_handle,t_int));
extern t_void poly_z_copy_term P_((t_handle,t_handle*,t_int,t_handle,t_int));
extern t_void poly_z_elt_delete P_((t_handle,t_poly *));
extern t_void poly_z_faclst_add_factor P_((t_handle,t_handle,t_poly,t_int));
extern t_void poly_z_faclst_delete P_((t_handle,dyn_arr_handle *));
extern t_void poly_z_faclst_join P_((t_handle,t_handle,t_handle));
extern t_void poly_z_faclst_write P_((t_handle,dyn_arr_handle));
extern t_handle poly_z_factorize P_((t_handle,t_poly));
extern t_void poly_z_gcd_cofactor P_((t_handle,t_poly,t_poly,t_poly*,t_poly*,t_poly *));
extern t_void poly_z_handle_delref P_((t_handle,t_handle));
extern t_void poly_z_integer_cont_prim_part P_((t_handle,t_poly,integer_big*,t_poly *));
extern t_void poly_z_lift P_((t_handle,t_poly,t_poly,t_poly*,t_poly *));
extern t_void poly_z_printable_delete P_((t_handle,t_poly));
extern t_void poly_z_quot_rem P_((t_handle,t_poly,t_poly,t_poly*,t_poly *));
extern t_void poly_z_write P_((t_handle,t_poly));

/* modpoly module protos */

extern t_poly modpoly_add P_((t_handle,integer_big,t_poly,t_poly));
extern t_poly modpoly_div P_((t_handle,integer_big,t_poly,t_poly));
extern t_poly modpoly_eval_lpvar P_((t_handle,integer_big,t_poly,integer_big));
extern t_poly modpoly_eval_princvar P_((t_handle,integer_big,t_poly,integer_big));
extern t_poly modpoly_evaluate P_((t_handle,integer_big,t_poly,t_int,integer_big));
extern t_poly modpoly_exp P_((t_handle,integer_big,t_poly,t_int));
extern t_poly modpoly_hom P_((t_handle,integer_big,t_poly));
extern t_poly modpoly_integer_mult P_((t_handle,integer_big,t_poly,integer_big));
extern t_poly modpoly_interpolate P_((t_handle,t_int,t_poly,t_int,t_int,t_poly,t_poly));
extern t_poly modpoly_max_norm P_((t_handle,integer_big,t_poly));
extern t_poly modpoly_monic P_((t_handle,integer_big,t_poly));
extern t_poly modpoly_mult P_((t_handle,integer_big,t_poly,t_poly));
extern t_poly modpoly_negate P_((t_handle,integer_big,t_poly));
extern t_poly modpoly_resultant P_((t_handle,t_int,t_poly,t_poly));
extern t_poly modpoly_subtract P_((t_handle,integer_big,t_poly,t_poly));
extern t_poly modpoly_sum_norm P_((t_handle,integer_big,t_poly));
extern t_poly modpoly_symm_rep P_((t_handle,integer_big,t_poly));
extern t_poly modpoly_uni_cont P_((t_handle,integer_big,t_poly));
extern t_poly modpoly_uni_cont_sub P_((t_handle,integer_big,t_poly,t_poly));
extern t_poly modpoly_uni_mult P_((t_handle,integer_big,t_poly,t_poly));
extern t_poly modpoly_uni_quot P_((t_handle,integer_big,t_poly,t_poly));
extern t_void modpoly_gcd_cofactor P_((t_handle,t_int,t_poly,t_poly,t_poly*,t_poly*,t_poly *));
extern void modpoly_quot_rem P_((t_handle,integer_big,t_poly,t_poly,t_poly*,t_poly *));
extern void modpoly_uni_contpp P_((t_handle,integer_big,t_poly,t_poly*,t_poly *));

/* poly_gf module protos */

extern t_poly poly_gf_abs P_((t_handle,t_poly));
extern t_poly poly_gf_add P_((t_handle,t_poly,t_poly));
extern t_poly poly_gf_clean P_((t_handle,t_poly));
extern t_poly poly_gf_constant_dims P_((t_handle,t_int,t_int,t_gf));
extern t_poly poly_gf_constant_poly P_((t_handle,t_poly,t_gf));
extern t_poly poly_gf_copy_poly P_((t_handle,t_poly));
extern t_poly poly_gf_deriv_princvar P_((t_handle,t_poly));
extern t_poly poly_gf_div P_((t_handle,t_poly,t_poly));
extern t_poly poly_gf_elt_incref P_((t_handle,t_poly));
extern t_poly poly_gf_eval_princvar P_((t_handle,t_poly,t_gf));
extern t_poly poly_gf_evaluate P_((t_handle,t_poly,t_int,t_gf));
extern t_poly poly_gf_exp P_((t_handle,t_poly,t_int));
extern t_poly poly_gf_high_deriv_princvar P_((t_handle,t_poly,t_int));
extern t_poly poly_gf_ith_deriv P_((t_handle,t_poly,t_int));
extern t_poly poly_gf_lbase_coefft P_((t_handle,t_poly));
extern t_poly poly_gf_lead_coefft P_((t_handle,t_poly));
extern t_poly poly_gf_lead_coefft_svar P_((t_handle,t_poly,t_int));
extern t_poly poly_gf_mult P_((t_handle,t_poly,t_poly));
extern t_poly poly_gf_negate P_((t_handle,t_poly));
extern t_poly poly_gf_reductum P_((t_handle,t_poly));
extern t_poly poly_gf_scalar_add P_((t_handle,t_poly,t_int));
extern t_poly poly_gf_scalar_div P_((t_handle,t_poly,integer_big));
extern t_poly poly_gf_scalar_mult P_((t_handle,t_poly,t_gf));
extern t_poly poly_gf_subtract P_((t_handle,t_poly,t_poly));
extern t_poly poly_gf_zero_poly P_((t_handle,t_poly));
extern t_handle glue_poly_gf_abs P_((t_handle,t_handle));
extern t_handle glue_poly_gf_add P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_poly_gf_div P_((t_handle,t_handle,t_handle));
extern t_handle glue_poly_gf_eq P_((t_handle,t_handle,t_int,t_handle,t_handle,t_int));
extern t_handle glue_poly_gf_exp P_((t_handle,t_handle,t_int,t_int,t_handle*,t_handle*,t_int *));
extern t_handle glue_poly_gf_is_one P_((t_handle,t_handle));
extern t_handle glue_poly_gf_mult P_((t_handle,t_handle,t_int,t_handle,t_int,t_handle*,t_int *));
extern t_handle glue_poly_gf_negate P_((t_handle,t_handle,t_handle *));
extern t_handle glue_poly_gf_scalar_add P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_poly_gf_scalar_div P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_poly_gf_scalar_mult P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_poly_gf_subtract P_((t_handle,t_handle,t_handle,t_handle *));
extern t_logical poly_gf_different P_((t_handle,t_poly,t_poly));

extern t_logical poly_gf_is_one_poly P_((t_handle,t_poly));
extern t_logical poly_gf_is_zero_poly P_((t_handle,t_poly));
extern t_void poly_gf_advance2 P_((t_handle,t_poly,t_int*,t_poly*,t_poly *));
extern t_void poly_gf_copy_term P_((t_handle,t_handle*,t_int,t_handle,t_int));
extern t_void poly_gf_elt_delete P_((t_handle,t_poly *));
extern t_void poly_gf_elt_print P_((t_handle,t_poly));
extern t_void poly_gf_elt_print_rec P_((t_handle,t_poly,t_logical));
extern t_void poly_gf_quot_rem P_((t_handle,t_poly,t_poly,t_poly*,t_poly *));

/* poly_u_z module protos */


extern t_poly poly_u_z_matrix_extract_poly P_((t_handle,t_matrix,t_poly,t_int));
extern t_poly poly_u_z_trunc_mult P_((t_handle,t_int,t_poly,t_poly));
extern t_handle poly_u_z_faclst_combine P_((t_handle,integer_big,t_poly,t_handle,t_bit_vector));
extern t_handle poly_u_z_sqfree_fact P_((t_handle,t_poly));
extern t_matrix poly_u_z_matrix_poly_to_row P_((t_handle,t_poly,t_int));
extern t_void poly_u_z_fact_deg_set P_((t_handle,t_poly,t_int*,t_handle*,t_bit_vector*,t_int));
extern t_void poly_u_z_factorize P_((t_handle,t_poly,t_int*,integer_big*,t_handle *));


/* poly_u_zm module protos */

extern dyn_arr_handle poly_u_zm_fact_b4 P_((t_handle,integer_big,t_poly,t_handle));
extern dyn_arr_handle poly_u_zm_fact_b4_small P_((t_handle,integer_big,t_poly,t_handle));
extern t_poly poly_u_zm_deriv P_((t_handle,integer_big,t_poly));
extern t_poly poly_u_zm_gcd P_((t_handle,integer_big,t_poly,t_poly));
extern t_poly poly_u_zm_high_deriv P_((t_handle,integer_big,t_poly,t_int));
extern t_poly poly_u_zm_mult P_((t_handle,integer_big,t_poly,t_poly));
extern t_poly poly_u_zm_nat_rem P_((t_handle,integer_big,t_poly,t_poly));
extern t_handle poly_mat_new P_((t_int,t_int));
extern t_handle poly_u_zm_dist_deg_fact P_((t_handle,integer_big,t_poly));
extern t_handle poly_u_zm_fact P_((t_handle,t_int,t_poly));
extern t_handle poly_u_zm_fact_b1 P_((t_handle,integer_big,t_poly,t_poly));
extern t_handle poly_u_zm_fact_b2 P_((t_handle,integer_big,t_poly));
extern t_handle poly_u_zm_fact_b2_large P_((t_handle,integer_big,t_poly));
extern t_handle poly_u_zm_fact_b2_small P_((t_handle,integer_big,t_poly));
extern t_handle poly_u_zm_fact_b3 P_((t_handle,integer_big,t_handle));
extern t_handle poly_u_zm_fact_b4_large P_((t_handle,integer_big,t_poly,t_handle));
extern t_handle poly_u_zm_hensel_list P_((t_handle,integer_big,t_handle,integer_big,t_poly));
extern t_int poly_u_zm_different P_((t_handle,integer_big,t_poly,t_poly));
extern t_int poly_u_zm_resultant P_((t_handle,t_int,t_poly,t_poly));
extern t_logical poly_u_zm_reducible P_((t_handle,t_int,t_poly));
extern t_void debug_univ_chk P_((t_poly));
extern t_void poly_u_zm_d_mult P_((integer_big,t_mat,t_int,t_int,t_int,t_int,t_int*,t_int));
extern t_void poly_u_zm_d_power_rem P_((integer_big,integer_big,t_matrix,t_int,t_int,t_int,t_int,t_int*,t_int,t_int));
extern t_void poly_u_zm_d_rem P_((integer_big,t_matrix,t_int,t_int,t_int,t_int,t_int*,t_int));
extern t_void poly_u_zm_half_xgcd P_((t_handle,integer_big,t_poly,t_poly,t_poly*,t_poly *));
extern t_void poly_u_zm_hensel_lemma P_((t_handle,integer_big,t_poly,t_poly,t_poly,t_poly,integer_big,t_poly,t_poly*,t_poly *));
extern t_void poly_u_zm_solve_eqn P_((t_handle,integer_big,t_poly,t_poly,t_poly,t_poly,t_poly,t_poly*,t_poly *));
extern t_void poly_u_zm_xgcd P_((t_handle,integer_big,t_poly,t_poly,t_poly*,t_poly*,t_poly *));

/* poly_zm module protos */


extern t_poly poly_zm_add P_((t_handle,t_poly,t_poly));
extern t_poly poly_zm_div P_((t_handle,t_poly,t_poly));
extern t_poly poly_zm_evaluate P_((t_handle,t_int,t_poly,integer_big));
extern t_poly poly_zm_exp P_((t_handle,t_poly,t_int));
extern t_poly poly_zm_gcd P_((t_handle,t_poly,t_poly));
extern t_poly poly_zm_mult P_((t_handle,t_poly,t_poly));
extern t_poly poly_zm_negate P_((t_handle,t_poly));
extern t_poly poly_zm_random P_((t_handle,t_int));
extern t_poly poly_zm_resultant P_((t_handle,t_poly,t_poly));
extern t_poly poly_zm_scalar_add P_((t_handle,t_poly,t_int));
extern t_poly poly_zm_scalar_div P_((t_handle,t_poly,t_int));
extern t_poly poly_zm_scalar_mult P_((t_handle,t_poly,t_int));
extern t_poly poly_zm_subtract P_((t_handle,t_poly,t_poly));
extern t_handle glue_poly_zm_add P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_poly_zm_derivative P_((t_handle,t_handle,t_handle));
extern t_handle glue_poly_zm_derivative_ithvar P_((t_handle,t_handle,t_handle,t_handle));
extern t_handle glue_poly_zm_discriminant P_((t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_poly_zm_div P_((t_handle,t_handle,t_handle));
extern t_handle glue_poly_zm_eq P_((t_handle,t_handle,t_int,t_handle,t_handle,t_int));
extern t_handle glue_poly_zm_exp P_((t_handle,t_handle,t_int,t_int,t_handle*,t_handle*,t_int *));
extern t_handle glue_poly_zm_gcd P_((t_handle,t_handle,t_handle));
extern t_handle glue_poly_zm_left_scalar_mult P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_poly_zm_mod P_((t_handle,t_handle,t_handle));
extern t_handle glue_poly_zm_mult P_((t_handle,t_handle,t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_poly_zm_negate P_((t_handle,t_handle,t_handle *));
extern t_handle glue_poly_zm_pfactorisation P_((t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_poly_zm_quotrem P_((t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_poly_zm_random_poly P_((t_handle,t_handle));
extern t_handle glue_poly_zm_resultant P_((t_handle,t_handle,t_handle));
extern t_handle glue_poly_zm_scalar_add P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_poly_zm_scalar_div P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_poly_zm_subtract P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_poly_zm_xgcd P_((t_handle,t_handle,t_handle,t_handle*,t_handle*,t_handle *));
extern t_handle poly_zm_derivative P_((t_handle,t_handle,t_handle));
extern t_handle poly_zm_derivative_ithvar P_((t_handle,t_handle,t_handle,t_handle));
extern t_handle poly_zm_discriminant P_((t_handle,t_poly));
extern t_handle poly_zm_reduce_modulo P_((t_handle,t_poly));

extern t_handle poly_u_zm_factorize P_((t_handle,t_poly));
extern t_void poly_zm_quot_rem P_((t_handle,t_poly,t_poly,t_poly*,t_poly *));

#endif /* _POLY_E_ */
