
#ifndef INCLUDE_MP_BUILD
#define INCLUDE_MP_BUILD

/*
Types and macros used by the mp_build functions.
*/

typedef
    struct
    {
	t_block_header		bld_trbl_hdr;
	mp_float		bld_final_z;
	mp_float		bld_temp_z;
	mp_int			bld_point;
	mp_sign_type		bld_sign;
	mp_sign_type		bld_expt_sign;
	mp_expt_type		bld_expt;
	mp_base_type		bld_in_base;

	enum mp_int
	{
	  MANT_SIGN,
	  MANT,
	  EXPT_SIGN,
	  EXPT
	}			bld_state;

    } build_data;

#define BUILD_DATA_LEN		byte_to_int(sizeof(build_data))


#define final_z(b)		((build_data *)mem_access(b))->bld_final_z
#define temp_z(b)		((build_data *)mem_access(b))->bld_temp_z
#define in_base(b)		((build_data *)mem_access(b))->bld_in_base
#define sign(b)			((build_data *)mem_access(b))->bld_sign
#define expt(b)			((build_data *)mem_access(b))->bld_expt
#define point(b)		((build_data *)mem_access(b))->bld_point
#define expt_sign(b)		((build_data *)mem_access(b))->bld_expt_sign
#define state(b)		((build_data *)mem_access(b))->bld_state

#define build_alloc()		mem_alloc_words_zero(BUILD_DATA_LEN)
#define build_delete(x)		mem_delete_hptr(x)

#endif /* INCLUDE_MP_BUILD */

