#include "kant.h"
#include "thue.h" 

t_logical
thue_waldschmidt WITH_3_ARGS(
                thue,           th,
                t_real *,       c4,
                t_real *,       c5
)
/*******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;
 
	integer_small	deg, nr, nr_max, r, l;
        integer_big     hh1;
	t_handle	R,Z;
	t_real		c1, c2, c3, c6, c7;
        t_real          D, e, vk1pl, vkpl, one, Ck, B1;
        order           ord;
        vector          v;
        t_logical       L;

        ord = thue_order(th);
        deg = thue_abs_degree(th);
        R = thue_reals(th);
        Z = m_z_str_incref(structure_z);
        r = order_r(ord);

        L = thue_waldschmidt_init(th);
        if (L == FALSE)
	        printf("Thue_waldschmidt_init erfolgreich ?   %d\n\n",L);

        c1 = thue_waldschmidt_c1(th);
        if (thue_print_level(th) >= 3)
                {
        	printf("c1 = "); real_write(R, c1, 20); puts("");        
                }

        c2 = thue_waldschmidt_c2(th);
        if (thue_print_level(th) >= 3)
                {
        	printf("c2 = "); real_write(R, c2, 20); puts("");        
                }

        c3 = thue_waldschmidt_c3(th, c1);
        if (thue_print_level(th) >= 3)
                {
        	printf("c3 = "); real_write(R, c3, 20); puts("");       
                }

        *c4 = thue_waldschmidt_c4(th, c2);
        if (thue_print_level(th) >= 3)
                {
        	printf("c4 = "); real_write(R, *c4, 20); puts("");      
                }  

        *c5 = thue_waldschmidt_c5(th, c3);
        if (thue_print_level(th) >= 3)
                {
        	printf("c5 = "); real_write(R, *c5, 20); puts("");
                }

/*        *c4 = thue_waldschmidt_c4_fast(th, *c5);
        if (thue_print_level(th) >= 4)
                {
        	printf("*** c4 = "); real_write(R, *c4, 20); puts(" ***");
                }
*/
        
        thue_B0(th) = thue_waldschmidt_B0(th, *c4, *c5);
        thue_B1(th) = real_incref(thue_B0(th) );
        if (thue_print_level(th) >= 3)
                {
        	printf("B0 = "); real_write(R, thue_B0(th), 20); puts("");
                }
        one = conv_int_to_real(R, 1);
        e = real_exp(R, one);
        real_delete(&one);
        Ck = thue_waldschmidt_C(R, deg);
        if (thue_print_level(th) >= 3)
                {
		printf("Ck = "); real_write(R, Ck, 20); puts("");
                }

        hh1 = integer_nfactorial(deg);
        D = conv_int_to_real(R, hh1); 
        integer_delete(&hh1);
        nr_max = dyn_arr_curr_length(thue_delta(th));

        for (nr=0; nr<nr_max; nr++)
                {
        	if (thue_print_level(th) >= 4)
			printf("delta%d\n",nr+1);
                v = thue_waldschmidt_Vi(th, D, nr);
        	if (thue_print_level(th) >= 4)
                	{
			printf("V : ");
			for (l=1; l<=r+1; l++)
                                {
				real_write(R, vec_entry(v, l), 20);printf(" | ");
                                }
			puts("");
                        }
                thue_waldschmidt_Vkplus(th, v, &vk1pl, &vkpl);
                c7 = thue_waldschmidt_c7(th, v, e, Ck, D, vk1pl);
                c6 = thue_waldschmidt_c6(th, c7, e, D, vkpl);
                B1 = thue_waldschmidt_B1(th, *c4,*c5,c6,c7);
	        if (thue_print_level(th) >= 4)
                	{
			printf("vk1pl = "); real_write(R, vk1pl, 20); puts("");
			printf("vkpl  = "); real_write(R, vkpl, 20); puts("");
			printf("c6 = "); real_write(R, c6, 20); puts("");
			printf("c7 = "); real_write(R, c7, 20); puts("");
			printf("B1 = "); real_write(R, B1, 20); puts("");
                        }
	        if (real_compare(R, thue_B1(th), B1) == -1)
                	{
                	real_delete(&thue_B1(th));
                        thue_B1(th) = B1;
                	}

                vec_delete(R, &v);
                real_delete(&vk1pl);
                real_delete(&vkpl);
                real_delete(&c6);
                real_delete(&c7);        
                } 
        real_delete(&c1);
        real_delete(&c2);
        real_delete(&c3);
        real_delete(&e);
        real_delete(&D);
        real_delete(&Ck);

	if (thue_print_level(th) >= 2)
                {
	        printf("Upper Bound B1 = ");real_write(R, thue_B1(th), 20); puts("");
                }

        return TRUE;
}
