#include "kant.h" 
#include "anf_rel_sort.h"



vector
rel_bases_con WITH_4_ARGS(
	order,		ord,
	order,		sub_ord,
	vector, 	rel_basis,
	anf_rel_sort, 	sort
)       
/*******************************************************************************
 
AJ January 1992
Last modification: 92-03-31 AJ    deletition of sqrt(2) for the imaginary conjugates 

 
 
 
Description:
 
	Computation of the different conjugated
	relative integral basis over the conjugated subfields of ord.

 
Calling sequence:
 
	rel_bases_con= rel_basis_con(ord, rel_basis, sort);
 
	order		ord		  t_handle of an order
        vector		rel_basis	= relativ integral basis over an subfield,
					  (rel_basis has representation as integer 
					   coefficients in ord)
	anf_rel_sort	sort		= the right order of the conjugates of ord
					  over the subfields
	vector		rel_bases_con	= a vector which contains the conjugated 
					  relative integral bases (complex numbers),
					  but not the conjugate complex

 
History:
 
	92-02-25 AJ    written
 
*******************************************************************************/
{  
	block_declarations;         

  	int		l, i, j, k, nm, m, n, int1, sub_r1, sub_r2, sub_r1r2;
   	t_handle          R, Z;                        
	vector		basis_con, rel_bases_con;  
                                    

/*** Initialisation:                   ****************************************/
/*** nm= [K:Q], m= [K:F], nm/m= [F:Q]  ****************************************/
                                   
                                    
        sub_r1= order_r1(sub_ord);
        sub_r2= order_r2(sub_ord);
        sub_r1r2= sub_r1+sub_r2;

	nm=  order_abs_degree(ord);  
	m= vec_length(rel_basis);
        n= nm/m;

        R = order_reals(ord);    
        Z= m_z_str_incref(structure_z);

/*** Computation of the conjugates of the relative basis   *******************/
                       
	basis_con= vec_new(m); 
          
	if (anf_print_level >= 3)
	 {
          printf("\nrel_bases_con: Output of RITB :\n\n");
          mat_real_write_aj(R,order_basis_real(ord) , 22); 
	 }

	for (i=1; i<=m; i++)
	  vec_entry(basis_con,i)= anf_elt_con(ord, vec_entry(rel_basis,i) );

	if (anf_print_level >= 3)
	 {
          printf("\nrel_bases_con: Output of basis_con :\n");
  	  for (i=1; i<=m; i++)
	   {
            anf_elt_write(ord,vec_entry(rel_basis,i)); printf("  =   "); 
            anf_elt_write(ord,vec_entry(basis_con,i)); printf("\n"); 
	   }
	 }

/*** Initialisation of the output vector rel_bases_con     *******************/

	rel_bases_con= vec_new(sub_r1r2);

	for (i=1; i<=sub_r1r2; i++)
	 vec_entry(rel_bases_con,i)= mat_new(m,m);

/*** Computation of the matrices    ******************************************/

	  for (j=1; j<=sub_r1r2; j++)
	   for (i=1; i<=m; i++)
	    {
 	     for (k=1; k<=m; k++) 
	      {                  
	      int1= anf_rel_sort_ordering_elt(sort,j,i);
              mat_elt(vec_entry(rel_bases_con,j),i,k)= 
	                        anf_elt_ith_con(ord, vec_entry(basis_con,k),int1);  
       	      }
	    }
	
/*** End *********************************************************************/

	for (l=1; l<=m; l++)
	 {
	  anf_elt_delete(ord, &vec_entry(basis_con,l));
	  vec_entry(basis_con,l)= 0;
	 }
	vec_delete(Z, &basis_con);
	ring_delete(&Z);

	return rel_bases_con;  

} 

