#include "kant.h" 



 
#define  SPACE	2000000                          

int	 workspace[SPACE];


main()  
/*******************************************************************************
 
AJ Januar 1992
Last modification: -.

 
 
 
Description:
 
	Creates a suborder and an order wich relates to the relative basis.
	
        
	 
	Planned: -.

 
Calling sequence:
 
	-
 
History:
 
	92-07-14 AJ    written
 
*******************************************************************************/
{
	block_declarations;         
         
  	int			i,j, n, nm, m; 
  	int			sub_r1, sub_r2, sub_r1r2; 
	t_logical			ok;

   	t_handle          	R, Z;  
	order			ord, sub_ord, rel_ord;   
        anf_elt         	a_elt, beta_elt, beta_elt_con; 

	t_real			t2_norm, h1, h2, h3;  

	anf_elt			elt_h1, elt_h2, elt_h3, rel_elt, ord_elt, elt_h4;
	matrix			trans_pow_ord, trans_pow_sub_ord;
	matrix			trans_sub_ord_ord, trans_rel_ord;
	matrix			trans_ord_rel;
	matrix			mat_h2, mat_h3, mat_h4, mat_h5;
	integer_big 		det, trans_ord_rel_den, denom;
	integer_big 		det_rel;
	vector			rel_basis;


/*** Initialisation  **********************************************************/

	kant_start(workspace, SPACE);

/*** Input loop  **************************************************************/
 
	while ( order_read(&ord)  ) 
	{   
          /*** Initialisation of the orders  ***/
             
		order_reals_set(ord, 20);
		order_reals_create(ord);
		order_mult_table_create(ord); 
		nm=  order_abs_degree(ord);  

                R = order_reals(ord);            
	        Z= m_z_str_incref(structure_z);

	        ok= order_find_suborder(ord, &sub_ord); 

		if (!ok) 
		 {
		  printf("\n\nThe second field is not a subfield!\n\n");
		  printf(  "Terminated.\n\n");  

		  goto no_subfield;
		 }     
 
		order_mult_table_create(sub_ord);
		n=  order_abs_degree(sub_ord);
		sub_r1=  order_r1(sub_ord);
		sub_r2=  order_r2(sub_ord);
		sub_r1r2=  sub_r1+sub_r2;
                                      
          /*** Construct a relative  basis  ***/

		m= nm/n;
		rel_basis= vec_new(m);  

		elt_h1= order_primitive_elt(ord);
	        for (i=1; i<=m; i++)      
	          vec_entry(rel_basis,i)= anf_power(ord, elt_h1, i-1);
	        anf_elt_delete(ord, &elt_h1);
	


          /*** Shortest primitive element   ***/

		beta_elt= order_shortest_primitive_elt(sub_ord);  

                /*** Output of beta_elt           ***/

                beta_elt_con= anf_elt_con(sub_ord, beta_elt);  
               
		if (anf_print_level >=2 )
		 {
		  printf("The conjugates of a shortest primitive");
	  	  printf(" element in the sub_order:\n\n");
                  anf_elt_write(sub_ord,beta_elt); printf("  =  \n");
                  anf_elt_write(sub_ord,beta_elt_con); printf("\n\n");
		 }

                /*** Output of the T_2-norm of beta_elt              ***/

		t2_norm= anf_elt_t2(sub_ord, beta_elt);

		if (anf_print_level >=2 )
		 {
                  printf("T_2-norm of this element:                 "); 		 
                  real_write(R, t2_norm, 20); printf("\n\n\n\n\n\n");
		 }


          /*** Find the representation of beta_elt_con in the integral  ***/
          /*** basis of ord                                             ***/


		if (anf_elt_embed_aj(sub_ord, beta_elt, 0, ord, &a_elt))
 		 {
		  if (anf_print_level >=2 )
		   {
		    printf("Representation of this element in the extention order:\n\n");
		    printf("   ");
                    anf_elt_write(ord,a_elt); printf(" =  ");
                    elt_h1= anf_elt_con(ord, a_elt);
                    anf_elt_write(ord,elt_h1); printf("\n");
		    printf("\nT2-Norm of this element: ");
		    h1= anf_elt_t2(ord, a_elt);
                    real_write(R, h1, 20); 
		    printf("\n\n");
		    real_delete(&h1);                    
		    anf_elt_delete(ord, &elt_h1);
		   }
	   	 }
		else
		 {
		  error_internal("main: The second field is not a subfield!\n\n"); 
		 }




          /*** Find the representation of the powers of the primitiv     ***/
	  /*** element in  sub_ord                                       ***/
                   
         	trans_pow_sub_ord= mat_new(n,n);
	
 		elt_h1= integer_anf_elt_lift(sub_ord, 1);
                anf_elt_to_mat_order_col(sub_ord, elt_h1, trans_pow_sub_ord, 1);
                anf_elt_to_mat_order_col(sub_ord, beta_elt, trans_pow_sub_ord, 2);
		anf_elt_delete(sub_ord, &elt_h1);

        	elt_h1= anf_elt_incref(beta_elt);
	        for (i=3; i<=n; i++)
		 {                  
		  elt_h2= elt_h1;
		  elt_h1= anf_mult(sub_ord, elt_h1, beta_elt);
		  anf_elt_delete(sub_ord, &elt_h2);
                  anf_elt_to_mat_order_col(sub_ord,elt_h1,trans_pow_sub_ord,i);
		 }
		anf_elt_delete(sub_ord, &elt_h1);  

		if (anf_print_level >=3 )
		 {
		  printf("\n\n\n\ntrans_pow_sub_ord= \n");
                  for (i=1; i<=n; i++)
		   {
                    for (j=1; j<=n; j++)
		      printf(" \t %d", mat_elt(trans_pow_sub_ord, i,j) );
	            printf("\n");
	           }
		  printf("\n \n");
		 }



          /*** Find the representation of the powers of the primitiv     ***/
	  /*** element of sub_ord in ord                                 ***/
                   
         	trans_pow_ord= mat_new(nm,n);
	
 		elt_h1= integer_anf_elt_lift(ord, 1);
                anf_elt_to_mat_order_col(ord, elt_h1, trans_pow_ord, 1);
                anf_elt_to_mat_order_col(ord, a_elt, trans_pow_ord, 2);
		anf_elt_delete(ord, &elt_h1);

        	elt_h1= anf_elt_incref(a_elt);
                for (i=3; i<=n; i++)
		 {            
		  elt_h2= elt_h1;
		  elt_h1= anf_mult(ord, elt_h1, a_elt);
		  anf_elt_delete(ord, &elt_h2);
                  anf_elt_to_mat_order_col(ord, elt_h1, trans_pow_ord, i);
		 }
		anf_elt_delete(ord, &elt_h1);


		if (anf_print_level >=3 )
		 {
		  printf("\n\ntrans_pow_ord= \n");
                  for (i=1; i<=nm; i++)
		   {
                    for (j=1; j<=n; j++)
		      printf(" \t %d", mat_elt(trans_pow_ord, i,j) );
	            printf("\n");
	           }
		  printf("\n \n");
		 }

          /*** Find the representation of the basis of sub_ord in ord    ***/

                mat_h2= mat_z_to_mat_real(R, trans_pow_ord);
                mat_h3= mat_z_to_mat_real(R, trans_pow_sub_ord);
                mat_h4= mat_ring_inverse(R,mat_h3);
		mat_h5= mat_ring_mult(R, mat_h2, mat_h4);  
	        trans_sub_ord_ord= mat_real_to_mat_z(R, mat_h5);

		if (anf_print_level >=3 )
		 {
		  printf("\n\nmat_h5= \n\n");
		  mat_real_write_aj(R, mat_h5, 15);
		  printf("\n \n");
		 }

		if (anf_print_level >=3 )
		 {
		  printf("\n\ntrans_sub_ord_ord= \n");
                  for (i=1; i<=nm; i++)
		   {
                    for (j=1; j<=n; j++)
		      printf(" \t %d", mat_elt(trans_sub_ord_ord, i,j) );
	            printf("\n");
	           }
		  printf("\n \n");
		 }

		mat_delref(R, &mat_h2);
		mat_delref(R, &mat_h3);
		mat_delref(R, &mat_h4);
		mat_delref(R, &mat_h5);
		                                    

          /*** Find the representation an relative element in ord       ***/
                                                                   
		trans_rel_ord= mat_new(nm, nm);
                for (i=1; i<=m; i++)
		 { 
                  elt_h1= anf_elt_incref(vec_entry(rel_basis,i));
                  for (j=1; j<=n; j++)
		   { 
		    elt_h3= mat_order_col_to_anf_elt(ord, trans_sub_ord_ord, j);
		    elt_h2= anf_mult(ord, elt_h1, elt_h3);
                    anf_elt_to_mat_order_col(ord, elt_h2, trans_rel_ord, (i-1)*n+j);
	  	    anf_elt_delete(ord, &elt_h2);
	  	    anf_elt_delete(ord, &elt_h3);
		   }
		  anf_elt_delete(ord, &elt_h1);
	         }

		if (anf_print_level >=3 )
		 {
		  printf("\n\ntrans_rel_ord= \n");
                  for (i=1; i<=nm; i++)
		   {
                    for (j=1; j<=nm; j++)
		      printf(" \t %d", mat_elt(trans_rel_ord, i,j) );
	            printf("\n");
	           }
		  printf("\n \n");
		 }
		 
		det= mat_z_det(Z, trans_rel_ord);
		det_rel= integer_incref(det);
		if (anf_print_level >=3 )
		 {
		  printf("\nDeterminant: ");
		  integer_write(det);
		  printf("\n \n");
		 }




          /*** Find the of ord in the relative basis if exists       ***/
                                                                   
		mat_h4= mat_z_to_mat_real(R, trans_rel_ord);
		h1=  conv_int_to_real(R, det); 
		h2= real_inverse(R, h1); 
		real_delete(&h1);
		h1= real_abs(R, h2);
		real_delete(&h2);
		mat_h5= mat_ring_scalar_right_mult(R,mat_h4,h1);
		mat_delref(R, &mat_h4);
		real_delete(&h1);
		mat_h4= mat_ring_inverse(R, mat_h5);

		if (anf_print_level >=3 )
        	 {
		  printf("\nmat_h4: \n\n");
		  mat_real_write_aj(R, mat_h4, 20);
		 }

	        trans_ord_rel= mat_real_to_mat_z(R, mat_h4);  
		trans_ord_rel_den= integer_abs(det);
		mat_delref(R, &mat_h4);
		mat_delref(R, &mat_h5);        


		mat_h4= mat_ring_mult(Z, trans_ord_rel, trans_rel_ord);
		if (anf_print_level >=3 )
		 {
		  printf("\n\nInverse test: \n");
                  for (i=1; i<=nm; i++)
		   {
                    for (j=1; j<=nm; j++)
		      printf(" \t %d", mat_elt(mat_h4, i,j) );
	            printf("\n");
	           }
		  printf("\n \n");
		 }
		mat_delref(Z, &mat_h4);


		if (anf_print_level >=3 )
		 {
		  printf("\n\ntrans_ord_rel= \n");
                  for (i=1; i<=nm; i++)
		   {
                    for (j=1; j<=nm; j++)
		      printf(" \t %d", mat_elt(trans_ord_rel, i,j) );
	            printf("\n");
	           }
		  printf("\n \n");
		 }

	        integer_delref(det);		 
		det= mat_z_det(Z, trans_rel_ord);
		if (anf_print_level >=3 )
		 {
		  printf("\nDenominator: ");
		  integer_write(trans_ord_rel_den);
		  printf("\n \n");
		 }
        
		
          /*** The order of relative basis multiplied by sub_ord basis  ***/

		if (det_rel==1)
	          rel_ord= order_incref(ord);
		 else
		  rel_ord= order_trans_down(ord, trans_rel_ord);

	        integer_delref(det);		 
	        integer_delref(det_rel);		 
		
		printf("(TSTFLG=)\n");
	  	printf("1 \n");
		order_write(rel_ord);
		order_write(sub_ord);
				 




          /*** End of while loop: delete storage  ***/ 
	
                for (i=1; i<=m; i++)
		 {
		  anf_elt_delete(ord, &vec_entry(rel_basis,i));
		  vec_entry(rel_basis,i)= 0;
	         }
		vec_delete(Z, &rel_basis);   


		anf_elt_delete (ord,&a_elt);

		anf_elt_delete (sub_ord,&beta_elt);	 
		anf_elt_delete (sub_ord,&beta_elt_con); 
 
		real_delete(&t2_norm);  

		mat_delref(Z, &trans_pow_ord);
		mat_delref(Z, &trans_pow_sub_ord);
		mat_delref(Z, &trans_sub_ord_ord);
		mat_delref(Z, &trans_rel_ord);
		mat_delref(Z, &trans_ord_rel);
		integer_delref(trans_ord_rel_den);
 		order_delete(&rel_ord); 


no_subfield:	order_delete(&ord);
 		order_delete(&sub_ord); 

		ring_delete(&Z);

	} 

/*** End  *********************************************************************/


}
