#include <stdio.h>         
#include "kant.h" 
#include "anf.h" 
#include "lattice.h" 
#include "real.e"
#include "poly.e"
#include "conv.e"


t_logical
anf_elt_embed_aj WITH_5_ARGS(
	order,		ord1,
	anf_elt,	alpha,
	t_poly,	alpha_poly,
	order,		ord2,
	anf_elt *,	alpha2
)
/*******************************************************************************
 
Description:
 
	Test if an element alpha in the order ord1 is in the order ord2.
	If this is the case we calculate a representation of alpha in ord2 
        (ord1, ord2 must be over Z).

 
Calling sequence:
 
	erg = anf_elt_embed(ord1, alpha, alpha_poly, ord2, alpha2);
 
      	order  	        ord1      	= t_handle of order of alpha
      	anf_elt         alpha	 	= algebraic number in ord1
	t_poly 	alpha_poly	= the minimal polynomial of alpha
					  (= MEM_NH if not known)
	order		ord2		= t_handle of second order
        anf_elt		alpha2		= the algebraic number alpha in the 
				 	  representation in ord2 (if possible)
	t_logical		erg		= 1, if the element representation of 
					     alpha in ord2 is found
					  0, else

 
History:
 
	92-06-10 JS	also the case that the degree of ord1 does not
                        divide the degree of ord2
	92-06-05 JS	order_reals_assure
	92-04-01 AJ     first version
 
*******************************************************************************/
{  
	block_declarations;         

  	int		i, nm, n;
   	t_handle        Z, R1, R2;
        t_real          ubound, h1, h2, h3, h4, h5, enum_range;    

	anf_elt		tst_elt, elt_h1;
	t_poly	min_poly1, min_poly2, poly_rem, poly_quot;

	lattice 	lat, lll_lat;
	lat_enum_env	env, lll_env;        
        lat_elt         lat_vec; 
        matrix          trans, inv_trans;

                                    

/*** Initialisation  **********************************************************/

	order_must_be_over_z(ord1);
	order_must_be_over_z(ord2);

	order_reals_assure(ord1);
	order_reals_assure(ord2);

	n=   order_abs_degree(ord1);
	nm=  order_abs_degree(ord2);

        R1 = order_reals(ord1);    
        R2 = order_reals(ord2);  
        Z= m_z_str_incref(structure_z);

	enum_range= conv_double_to_real(R2, 1.0001);
  
/*** Computation of an upper bound for alpha  ******************************/
                           
        h1= anf_elt_t2(ord1, alpha);
	h2= conv_real_to_real(h1, R1, R2);
        h3= conv_int_to_real(R2, nm);
        h4= conv_int_to_real(R2, n);
        h5= real_divide(R2, h3, h4);
 
	ubound= real_mult(R2, h2, h5);

	if (anf_print_level > 3)
	 {                   
	  printf("anf_elt_embed: Upper bound for enumeration = ");
	  real_write(R2, ubound, 10);
	  printf("\n");
	 }

	real_delete(&h1);
	real_delete(&h2);
	real_delete(&h3);
	real_delete(&h4);
	real_delete(&h5);


/*** Computation of the minimal polynomial of alpha  *************************/
 
/*
	if (alpha_poly != MEM_NH)
	  min_poly1= m_poly_z_incref(structure_pring_z, alpha_poly);
	 else
	  min_poly1= anf_elt_minpoly(ord1, alpha); 
*/

/*** Initialisation of enumeration environment  ******************************/

	order_lat(ord2, &lat, &env);

                                         
        lll_lat = lat_lll_reduce(lat,&trans,&inv_trans);
        lll_env = lat_enum_create(lll_lat);
	lat_enum_ubound(lll_env) = real_mult(R2, ubound, enum_range);
	lat_enum_lbound(lll_env) = real_divide(R2, ubound, enum_range);
 
        lat_enum_status_set_new   (lll_env);
        lat_enum_request_set_next (lll_env);
        lat_enum_strategy_set_up  (lll_env);          

	
/*** Loop of the enumeration   ***********************************************/
                                
	while (lat_enum(lll_lat,lll_env))
	{      
 
     /*** Test if the found element is alpha                            ****/

	  /** Construction of the algebraic element from the lattice vector **/

           lat_vec  = lat_elt_move (lll_lat,lat_enum_act_coefs(lll_env),trans);
                             
           tst_elt = lat_elt_to_anf_elt (lat, lat_vec, ord2);
 	   lat_elt_delete (lll_lat,&lat_vec);

           if (anf_print_level>3)
            {
             printf("\ntst_elt:  ");
             anf_elt_write(ord2,tst_elt);
             printf("\n \n");
            }
 
/*
	   min_poly2= anf_elt_minpoly(ord2, tst_elt);
           poly_z_quot_rem(structure_pring_z, min_poly2, min_poly1, &poly_quot, &poly_rem);

 	   if (poly_is_zero(structure_pring_z, poly_rem)) 
	    {                                             
*/
           if (anf_elts_same_con_aj(ord2, ord1, tst_elt, alpha) )
            {
 	     /** Returning the element found                                **/
              
	     *alpha2= anf_elt_incref(tst_elt);

	     anf_elt_delref(ord2,&tst_elt);
	     real_delete(&ubound);
	     real_delete(&enum_range);   
/*
	     m_poly_z_delref(structure_pring_z, min_poly1);
	     m_poly_z_delref(structure_pring_z, min_poly2);
	     m_poly_z_delref(structure_pring_z, poly_quot);
	     m_poly_z_delref(structure_pring_z, poly_rem);
*/
	     lat_enum_delete(lat,&env);
	     lat_delete(&lat);
	     lat_enum_delete(lll_lat,&lll_env);
	     lat_delete(&lll_lat);
             mat_delref(Z,&trans);
             mat_delref(Z,&inv_trans);
             ring_delete(&Z);

             return TRUE;
 	    }                                       
           
	   elt_h1= tst_elt;
	   tst_elt= anf_negate(ord2, elt_h1);
	   anf_elt_delete(ord2, &elt_h1);

/*	   
           m_poly_z_delref(structure_pring_z, min_poly2);
	   min_poly2= anf_elt_minpoly(ord2, tst_elt);
	   m_poly_z_delref(structure_pring_z, poly_quot);
	   m_poly_z_delref(structure_pring_z, poly_rem);
           poly_z_quot_rem(structure_pring_z, min_poly2, min_poly1, &poly_quot, &poly_rem);

 	   if (poly_is_zero(structure_pring_z, poly_rem)) 
	    {      
*/
           if (anf_elts_same_con_aj(ord2, ord1, tst_elt, alpha) )
            {
  	     /** Returning the element found                                **/
              
	     *alpha2= anf_elt_incref(tst_elt);

	     anf_elt_delref(ord2,&tst_elt);
	     real_delete(&ubound);
	     real_delete(&enum_range);
/*
	     m_poly_z_delref(structure_pring_z, min_poly1);
	     m_poly_z_delref(structure_pring_z, min_poly2);
	     m_poly_z_delref(structure_pring_z, poly_quot);
	     m_poly_z_delref(structure_pring_z, poly_rem);
*/
	     lat_enum_delete(lat,&env);
	     lat_delete(&lat);
	     lat_enum_delete(lll_lat,&lll_env);
	     lat_delete(&lll_lat);
             mat_delref(Z,&trans);
             mat_delref(Z,&inv_trans);
             ring_delete(&Z);



             return TRUE;
 	    }                                       


	   anf_elt_delref(ord2,&tst_elt); 
/*
	   m_poly_z_delref(structure_pring_z, min_poly2);
	   m_poly_z_delref(structure_pring_z, poly_quot);
	   m_poly_z_delref(structure_pring_z, poly_rem);
*/

	}   /* end while */ 
	
/*** End *********************************************************************/


        real_delete(&ubound);
	real_delete(&enum_range);
/*
        m_poly_z_delref(structure_pring_z, min_poly1);
*/
        lat_enum_delete(lat,&env);
        lat_delete(&lat);
	lat_enum_delete(lll_lat,&lll_env);
	lat_delete(&lll_lat);
        mat_delref(Z,&trans);
        mat_delref(Z,&inv_trans);
        ring_delete(&Z);



	return FALSE;

} 

