#include "defs.h"
#include "zm.e"
#include "error.e"

public t_handle
zm_power( ring, a, it1, b, res_s, res_e, res_it )
t_handle ring, a, it1, b, *res_s, *res_e, *res_it;
/*
** returns a^b where a is in Z_m and b is in Z
*/
{
	block_declarations;
	t_handle	res, temp;
	integer_big	absb;
	t_int		sign;
	t_logical	inv_flag = FALSE;

	sign = integer_sign (b);
	switch (sign)
	{
	case  0:
		return 1;
	case -1:
		if (!zm_unit(ring, a))
		{
			error_runtime (ERR_NEG_POWER_OF_NON_UNIT, b, a);
		}
		inv_flag = TRUE;
	case  1:
		absb = integer_abs (b);
		res = modint_exp (zm_modulus (ring), a, absb);
		break;
	default:
		error_internal ("Something went very wrong in zm_power");
	}
	integer_delete (&absb);
	if (inv_flag)
	{
		temp = res;
		res = zm_inverse (ring, temp);
		integer_delete (&temp);
	}
	*res_e = res;
	*res_s = m_zm_str_incref(ring);
	return NH;
}
