#include "defs.h"
#include "zm.e"

public integer_big
zm_inverse (ring, a)
t_handle		ring;
integer_big		a;
/*
 * inversion in (Z_m) ring of a
 * if a is not a unit, 0 is returned!
 */
{
	block_declarations;

	integer_big	gcdint;
	integer_big	uint, mint;
	integer_big	resint;
	integer_big	temp;

	mint = zm_modulus(ring);
	integer_gcd_mult( mint, a, &gcdint, &uint, &resint );
	if( gcdint != 1 )
	{
		integer_delref( gcdint );
		integer_delref( uint );
		return 0;
	}
        /* ensure result is positive but reduced mod mint */

	if ( integer_sign( resint ) < 0 )
	{
		temp = resint;
		resint = integer_add( mint, temp );
		integer_delref( temp );

		return resint;
	}

        return  resint;

}
