#include "defs.h"
#include "error.e"
#include "real.e"
#include "mp.h"

static mp_build_context bc;

static void
add_digit	WITH_1_ARG(
	t_int,	dig
)
{
    if (dig == '-')
    {
	mp_build_minus(bc);
    }
    else
    {
	mp_build_digit(bc, dig-'0');
    }
}

t_real
real_make WITH_3_ARGS(
	t_handle,		r,
	integer_big,	mantissa,
	t_int,	exponent
)
/*
Returns a real with the given mantissa and exponent.
*/
{
    mp_float		f;

    if ( ! integer_is_single( exponent ))
    {
        error_runtime( ERR_ARG_TOO_BIG, 3, exponent );
    }

    f = mp_alloc(real_base, real_beta_prec(r));
    bc = mp_build_start(f, 10);
    integer_break(mantissa, add_digit);
    mp_build_expt(bc);
    integer_break(exponent, add_digit);
    mp_build_finish(&bc);

    return mp_to_real(f);
}

