#include "defs.h"
#include "integer.e"
#include "q.h"

rational
q_int_mult WITH_3_ARGS(
	t_handle,		field,
	rational,	a,
	integer_big,	b
)
/*
** Returns the product of rational a and integer b.
*/
{
    block_declarations;
    rational		c;

    if (a == 0 || b == 0)
    {
	return 0;
    }

    if (b == 1)
    {
	return q_incref(a);
    }

    c = q_new();
    q_numer(c) = integer_mult(q_numer(a), b);
    q_denom(c) = integer_incref(q_denom(a));
    q_simplify(c);

    return c;
}

