
#include "defs.h"
#include "integer.e"
#include "q.h"

rational
q_divide WITH_3_ARGS(
	t_handle,		field,
	rational,	a,
	rational,	b
)
/*
Returns the quotient of rationals a and b.
*/
{
    block_declarations;
    rational		c;
    integer_big		t1, t2;

    DENY(b == 0);

    if (a == 0)
    {
	return 0;
    }

    if (b == Q_ONE)
    {
	return q_incref(a);
    }

    c = q_new();
    q_numer(c) = integer_mult(t1=q_numer_fun(field, a),t2=q_denom_fun(field, b));
    integer_delref(t1); integer_delref(t2);
    q_denom(c) = integer_mult(t1=q_denom_fun(field, a), t2=q_numer_fun(field, b));
    integer_delref(t1); integer_delref(t2);
    q_simplify(c);

    return c;
}

