#include "defs.h"
#include "integer.e"
#include "q.h"

t_int
q_compare WITH_3_ARGS(
	t_handle,		field,
	rational,	a,
	rational,	b
)
/*
Returns:
	 0		if a == b,
	+1		if a > b,
	-1		if a < b.
*/
{
    block_declarations;
    t_int	result;
    integer_big		temp1, temp2;

    if (a == 0 && b == 0)
    {
	return 0;
    }

    if (a == 0)
    {
	q_fix_sign(b);
	return integer_compare(0, q_numer(b));
    }

    if (b == 0)
    {
	q_fix_sign(a);
	return integer_compare(q_numer(a), 0);
    }

    q_fix_sign(a);
    q_fix_sign(b);

    temp1 = integer_mult(q_numer(a), q_denom(b));
    temp2 = integer_mult(q_denom(a), q_numer(b));

    result = integer_compare(temp1, temp2);

    integer_delref(temp1);
    integer_delref(temp2);

    return result;
}

