#include "defs.h"
#include "poly.h"
#include "dyn_arr.h"
#undef DEBUG


#ifndef KANT
#include "chstr.e"
#include "frame.e"
#endif /* KANT */

static t_void poly_z_write_rec P_((t_handle,t_poly,t_logical));

t_void
poly_z_write WITH_2_ARGS(
    t_handle,     pring,
    t_poly,    apoly
)
{
    t_poly ppoly;

    ppoly = poly_z_printable_poly (pring, apoly);
    poly_z_write_rec(m_poly_named_ring (pring), ppoly, FALSE);
    poly_z_printable_delete (pring, ppoly);
}

private t_void
poly_z_write_rec WITH_3_ARGS(
    t_handle,     pring,
    t_poly,    apoly,
    t_logical,    recursed
)
/*
** poly_z_write() : Writes out the polynomial on standard output
*/
{
    block_declarations;
    integer_big    nterms;
    integer_big    termno;
    t_poly      acoefft;
    t_int  aexpt;
    t_handle         aph;      
    t_handle         var_name;      
    t_int  var_num;      
    integer_big    aabs;
    t_poly      temp;

    if (m_poly_const (apoly))
    {
        integer_write (apoly);
        return;
    }

    aph = m_poly_poly_to_handle( apoly );
    nterms = m_poly_nterms( aph );
    var_num = (m_poly_nvars (pring)) - (m_poly_princvar (aph)) + 1;

    if (recursed && nterms > 1)
        cay_print ("(");

    for (termno = --nterms; termno >= 0; termno -- )
    {
        acoefft = m_poly_coefft( aph, termno );
        aexpt = m_poly_expt( aph, termno );

        if (m_poly_const (acoefft))
        {
            if (integer_sign (acoefft) == -1)
            {
                aabs = integer_negate (acoefft);
				if (termno == nterms && recursed && nterms > 1)
                    cay_print ("-");
                else
                    cay_print (" - ");
            }
            else
            {
                aabs = integer_incref (acoefft);
                if (termno != nterms)
                    cay_print (" + ");
            }
            if (aexpt == 0)
            {
                integer_write (aabs);
                integer_delref (aabs);
				continue;
			}
            if (aabs != 1)
            {
                integer_write (aabs);
                integer_delref (aabs);
                cay_print ("*");
            }
        }
		else if (aexpt == 0)
		{
			if (termno != nterms)
			{
				if (poly_z_sign (pring, acoefft) != -1)
				{
					cay_print (" + ");
				}
				else
				{
					temp = poly_z_lead_coefft(pring, acoefft);
					if (! poly_is_monomial (temp))
						cay_print (" + ");
					m_poly_z_delref (pring, temp);
				}
			}
			poly_z_write_rec (pring, acoefft, FALSE);
			continue;
		}
        else
        {
            if (termno != nterms)
                cay_print (" + ");
            poly_z_write_rec (pring, acoefft, TRUE);
            cay_print ("*");
        }
#ifndef KANT
        var_name = frame_gen_name (pring, var_num);
        cay_print( "%s", chstr_access (var_name));
        chstr_elt_delete( 0, &var_name);
#else
	cay_print("x");
#endif /* KANT */
        if ( aexpt >= 2 )
        {
            cay_print( "^%d", aexpt );
        }
    }

    if (recursed && nterms > 0)
        cay_print (")");
}

