#include "defs.h"
#include "poly.h"
#include "poly_z_faclst.h"
#include "globals.e"
#ifndef KANT
#include "tuple.e"
#include "ecart.e"
#include "eseq.e"


t_handle
poly_z_farray_to_feseq(pring, sign, content, flist)
t_handle	pring;
t_int		sign;
t_integer	content;
t_handle	flist;
/* 
** This routine takes sign content and a factor array and
** returns the sequence of tuples the last of which is the 
** sign * content. IT DESTROYS FLIST.
*/
{
	block_declarations;
	t_int		len, i;
	t_ecart		cart;
	t_tuple		t;
	t_handle	seq1;
	integer_big	c;
	t_poly	lastfac;

	c = (sign < 0) ? integer_negate(content) : integer_incref(content);

	len = m_poly_z_faclst_len (flist);
        ASSERT(len);
        cart = ecart_str_create( 2, ECART_NO_PRINT, pring, 1, structure_z, 1 );
	if (c == 1)
		seq1 = eseq_create (len, cart);
	else
	{
		lastfac=poly_z_constant_poly(pring,m_poly_z_faclst_factor(flist,0),c);
		seq1 = eseq_create (len + 1, cart);
	}
 
        for (i = 0; i<len; i++)                 
        {
                t = tuple_create( cart, 2, 
                	pring, m_poly_z_faclst_factor (flist, i), 0,
                	structure_z, m_poly_z_faclst_power (flist, i), 0);
                poly_z_elt_delete(pring, &(m_poly_z_faclst_factor(flist, i)));
		eseq_put(seq1, i+1, t, 0);
		m_tuple_delete(t);
	}

	if (c != 1) /* If the content isn't 1, make it the last factor. */
	{
		t = tuple_create( cart, 2, pring, lastfac, 0, structure_z, 1, 0);
		poly_z_elt_delete(pring, &lastfac);
		eseq_put(seq1, len + 1, t, 0);
		m_tuple_delete(t);
	}

	m_ecart_str_delete(cart);
	integer_delref(c);
	block_decref_delete (flist);
        return  seq1;
}

#endif /* KANT */


t_void
poly_z_farray_add_content(pring, sign, content, flist)
t_handle	pring;
t_int		sign;
t_integer	content;
t_handle	flist;
/* 
** This routine takes sign content and a factor array and
** adds the sign * content on as a final factor expressed
** in full recursive form. (Unless it is one.)
*/
{
	block_declarations;
	t_int		len;
	integer_big	c;

	c = (sign < 0) ? integer_negate(content) : integer_incref(content);
	if ( c == 1) 
		return;

	len = m_poly_z_faclst_len (flist);
        ASSERT(len);
	m_poly_z_faclst_assure_space(flist, len+1);
	m_poly_z_faclst_factor(flist, len) = 
		poly_constant_poly(pring, m_poly_z_faclst_factor(flist, len - 1) , c);
	integer_delref(c);
}

	
