
#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "poly_z_faclst.h"

void
poly_z_faclst_join WITH_3_ARGS(
    t_handle,      pring,
    t_handle,        resmh,
    t_handle,        addmh
)
/*
** combines addmh into resmh
*/
{
    t_int    i;
    t_poly        addent;
    t_int    addpow;
    t_int    len;

    len = m_poly_z_faclst_len( addmh );

    for ( i=0; i<len; ++i )
    {
	addent = m_poly_z_faclst_factor( addmh, i );
	addpow = m_poly_z_faclst_power( addmh, i );

	poly_z_faclst_add_factor( resmh, pring, addent, addpow );
    }
}

