#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "error.e"

t_poly
poly_z_clean WITH_2_ARGS(
    t_handle,    pring,
    t_poly,   apoly
)
/*
*  IPOLY_CLEAN deletes unnecessary zero coefficients within a
*  polynomial to conform to the rules satisfying clean polynomials.
*  Also deletes empty terms.
*/
{
    block_declarations;
    t_handle           aph;
    t_poly        temp;

    if ( m_poly_const (apoly) )
    {
        /* apoly is a constant term */

        return  apoly;
    }

    aph = m_poly_poly_to_handle (apoly);
    

    if ( m_poly_nterms (aph) == 0 )
    {
        /* empty polynomial */

        temp = poly_z_zero_poly (pring, apoly);
        m_poly_z_delref (pring, apoly);
        return  (temp);
    }

    temp = poly_z_clean_rec (pring, apoly);

    if (temp == 0)
    {
        temp = poly_z_zero_poly (pring, apoly);
    }

    m_poly_z_delref (pring, apoly);
    return (temp);

} /* poly_z_clean() */



public t_poly
poly_z_clean_rec WITH_2_ARGS (
    t_handle,     pring,
    t_poly,    apoly
)
{
    block_declarations;
    t_handle           aph;
    t_handle           resh;
    t_int    nterms;
    t_int    atermno;
    t_int    restermno;
    t_poly        acoefft;
    t_poly        temp;
#ifdef DEVELOP
    t_int    last_exp;
    t_int    this_exp;
    last_exp = -1;
#endif /* DEVELOP */

    if (apoly == 0)
        return 0;

    aph = m_poly_poly_to_handle (apoly);
    nterms = m_poly_nterms (aph);
    m_poly_create_empty(&resh, m_poly_princvar(aph), 
                                        m_poly_least_pvar(aph), nterms);
    if (m_poly_univariate (aph))
    {
        for (restermno = 0, atermno = 0; atermno < nterms; atermno ++)
        {
            acoefft = m_poly_coefft (aph, atermno);
            if (acoefft)
            {
                m_poly_coefft(resh, restermno) = integer_incref(acoefft);
#ifdef DEVELOP
                this_exp = m_poly_expt( aph, atermno);
                ASSERT (last_exp < this_exp);
                m_poly_expt (resh, restermno) = this_exp;
                last_exp = this_exp;
#else /* DEVELOP */
                m_poly_expt( resh, restermno) = m_poly_expt( aph, atermno);
#endif /* DEVELOP */
                restermno ++;
            }
        }
        if (restermno == 0)
        {
            poly_z_handle_delref (pring, resh);
            return(0);
        }
        poly_minspace (resh, restermno);
        return (m_poly_handle_to_poly (resh));
    }

    for (restermno = 0, atermno = 0; atermno < nterms; atermno ++)
    {
        acoefft = m_poly_coefft (aph, atermno);
        temp = poly_z_clean_rec (pring, acoefft);
        if (temp != 0)
        {
            m_poly_coefft(resh, restermno) = temp;
#ifdef DEVELOP
            this_exp = m_poly_expt( aph, atermno);
            ASSERT (last_exp < this_exp);
            m_poly_expt (resh, restermno) = this_exp;
            last_exp = this_exp;
#else /* DEVELOP */
            m_poly_expt( resh, restermno) = m_poly_expt( aph, atermno);
#endif /* DEVELOP */
            restermno ++;
        }
    }
    if (restermno == 0)
    {
        poly_z_handle_delref (pring, resh);
        return(0);
    }
    poly_minspace (resh, restermno);
    return (m_poly_handle_to_poly (resh));

} /* poly_z_clean_rec() */
