#include "defs.h"
#include "debug.e"
#include "integer.e"
#include "poly.h"
#include "poly_z_faclst.h"
#include "poly_mat.h"
#include "error.e"

t_handle
poly_u_zm_fact_b2 WITH_3_ARGS(
    t_handle,      pring,
    integer_big,   pdig,     /* field modulus */
    t_poly,    apoly
)
/*
** MODUPOLY_FACT_B2: Modular univariate polynomial Berlekamp
** Q matrix construction - Step 2 .
** pdig: prime beta-integer.
** apoly: uivariate polynomial over Zpdig.
** deg( apoly ) >= 2 .
** Returns the Q matrix for apoly as defined in Knuth p 425.
*/
{
	IF_DEBUG_FLAG( DEBUG_MODUPOLY_FACT_B2,
	{
		block_declarations;
		t_matrix		Qhdl_large;
		t_matrix		Qhdl_small;
		t_int	i;
		t_int	j;
		t_int	m;
		t_int	n;
		integer_big	temp;

		Qhdl_large = poly_u_zm_fact_b2_large( pring, pdig, apoly );
		Qhdl_small = poly_u_zm_fact_b2_small( pring, pdig, apoly );

		m = m_poly_mat_row( Qhdl_large );
		n = m_poly_mat_col( Qhdl_large );

		if ( m != m_poly_mat_row( Qhdl_small ) || n != m_poly_mat_col( Qhdl_small ))
		{
			error_internal( "poly_u_zm_fact_b2_{small,large}() return different size matrices" );
		}

		for ( i=1; i<=m; ++i )
		{
			for ( j=1; j<=n; ++j )
			{
				temp = m_poly_mat_elt( Qhdl_small, i, j );
				if ( integer_compare( temp, m_poly_mat_elt( Qhdl_large, i, j )) != 0 )
				{
					error_internal( "poly_u_zm_fact_b2_{small,large}() return different matrix elements" );
				}
				integer_delref( temp );
			}
		}

		mem_delete_h( Qhdl_small );

		return Qhdl_large;
	}
	);

	if ( pdig < poly_deg( apoly ))
	{
		return poly_u_zm_fact_b2_small( pring, pdig, apoly );
	}
	else
	{
		return poly_u_zm_fact_b2_large( pring, pdig, apoly );
	}
}
