#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "zm.e"
#include "error.e"

t_poly
poly_u_zm_deriv WITH_3_ARGS(
        t_handle,       pring,
        integer_big,    mdig,
        t_poly,      apoly
)
/*
** poly_u_zm_deriv : derivative 
** apoly is an modular univariate polynomial over Zmdig.
** returns the derivative of apoly mod mdig.
*/
{
    t_int    resph;
    t_int    aph;
    t_poly        coefft;
    t_int    expt;
    t_int    nterms;
    t_int    termno;
    t_int    restermno;
    t_poly        temp;

    if ( m_poly_const( apoly ) )
    {
        return 0;
    }

    /* apoly is non-constant */

    aph = m_poly_poly_to_handle( apoly );
    nterms = m_poly_nterms( aph );
    m_poly_create_empty(&resph, m_poly_princvar (aph),
                                       m_poly_least_pvar (aph), nterms );
    restermno = 0;

    for ( termno = 0; termno < nterms; termno++ )
    {
        expt = m_poly_expt( aph, termno );
        if ( expt != 0 )    /* ignore terms with expt == 0 */
        {
            coefft = m_poly_coefft( aph, termno );

            /* multiply coefficient by exponent */
            /* all coeffts are const            */

            DENY ( m_poly_not_const( coefft ));

            temp = modint_mult( mdig, coefft, expt );
                
            if ( temp != 0 )
            {
                m_poly_coefft( resph, restermno ) = temp;
                m_poly_expt( resph, restermno ) = expt - 1;
                restermno++;
            }
        }
    }

    m_poly_nterms( resph ) = restermno;
    return poly_z_clean (pring, m_poly_handle_to_poly (resph));
}



t_poly
poly_u_zm_high_deriv WITH_4_ARGS(
        t_handle,         pring,
        integer_big,      mdig,
        t_poly,        apoly,
        t_int,    k
)
/*
** poly_u_zm_high_deriv : modular univariate polynomial higher derivative 
** variable. 
** mdig is a beta-integer.
** apoly is a poly in several variables.    
** k is a non-negative gamma-integer.    
** Returns k-th derivative of apoly, as a poly mod mdig.    
*/
{
    block_declarations;
    t_int    i;
    t_poly        respoly;
    t_poly        temp;

    ASSERT ( m_poly_univariate( apoly ));

    i = k;
    respoly = m_modpoly_incref( pring, apoly );

    while ( ( i > 0 ) && ( ! poly_z_is_zero_poly (pring, respoly)))
    {
        /* continually take derivative until kth derivative or */
        /* a zero result is obtained               */

        temp = respoly;
        respoly = poly_u_zm_deriv( pring, mdig, temp );
        m_modpoly_delref( pring, temp );
        --i;
    }

    return respoly;
}

