#include "defs.h"
#include "debug.e"
#include "integer.e"
#include "poly.h"
#include "poly_mat.h"
#include "error.e"

t_void
poly_u_zm_d_power_rem WITH_10_ARGS(
	integer_big,		pdig,
	integer_big,		power,
	t_matrix,			phdl,
	t_int,		deg1,
	t_int,		arg1,
	t_int,		deg2,
	t_int,		arg2,
	t_int *,	degres,
	t_int,		arg3,
	t_int,		arg4
)
/*
** calculate phdl( row arg1 ) ^ power ( mod pdig and mod phdl( row arg2 )
** using phdl( rows arg3 and arg4 ) as temporary space, phdl( row arg2 )
** of length deg2, all rows 2*deg1 long, arg1 of length deg1. Result
** goes into phdl( row arg3 ). pdhl( row arg2 ) remains unchanged.
** phdl( row arg1 ) is destroyed.
*/
{
	block_declarations;
	t_int	j;
	integer_big	p;
	integer_big	temp;
	t_int	len;
	t_int	arg3off;
	t_int	deg3;
	t_int	deg4;

	len = m_poly_mat_col( phdl );

	DENY( len < deg2 + deg2 - 3 );

	arg3off = (arg3 - 1) * len;

	temp = m_poly_mat_entry( phdl, arg3off + 1 );
	integer_delref( temp );
	m_poly_mat_entry( phdl, arg3off + 1 ) = 1;
	deg3 = 1;

	/* this may not be needed */
	for ( j=2; j<=len; ++j )
	{
		temp = m_poly_mat_entry( phdl, arg3off + j );
		integer_delref( temp );
		m_poly_mat_entry( phdl, arg3off + j ) = 0;
	}

	IF_DEBUG_FLAG( DEBUG_MODUPOLY_D_POWER_REM,
	{
		cay_print( "entering poly_u_zm_d_power_rem(), pdig = %d, power = %d\n", pdig, power );
		cay_print( "arg1 = %d (%d),  arg2 = %d (%d),  arg3 = %d,  arg4 = %d\n", arg1, deg1, arg2, deg2, arg3, arg4 );
		cay_print( "initial phdl = \n" );
		poly_z_Qmatrix_write( phdl );
	}
	);

	p = integer_incref( power );

	for ( ;; )
	{
		if ( integer_rem( p, 2 ) == 1 )
		{
			/*
			** c := b * a;
			*/

			poly_u_zm_d_mult( pdig, phdl, deg1, arg1, deg3, arg3, &deg4, arg4 );

			IF_DEBUG_FLAG( DEBUG_MODUPOLY_D_POWER_REM,
			{
				cay_print( "mult %d * %d into %d to produce\n", arg1, arg3, arg4 );
				poly_z_Qmatrix_write( phdl );
			}
			);

			/*
			** b := c mod apoly;
			*/

			poly_u_zm_d_rem( pdig, phdl, deg4, arg4, deg2, arg2, &deg3, arg3 );

			IF_DEBUG_FLAG( DEBUG_MODUPOLY_D_POWER_REM,
			{
				cay_print( "mod %d by %d into %d to produce\n", arg4, arg2, arg3 );
				poly_z_Qmatrix_write( phdl );
			}
			);
		}

		temp = p;
		p = integer_div( temp, 2 );
		integer_delref( temp );

		if ( p == 0 )
		{
			*degres = deg3;
			goto EXIT;
		}

		/*
		** c := a * a;
		*/

		poly_u_zm_d_mult( pdig, phdl, deg1, arg1, deg1, arg1, &deg4, arg4 );

		IF_DEBUG_FLAG( DEBUG_MODUPOLY_D_POWER_REM,
		{
			cay_print( "mult %d * %d into %d to produce\n", arg1, arg1, arg4 );
			poly_z_Qmatrix_write( phdl );
		}
		);

		/*
		** a := c mod apoly;
		*/

		poly_u_zm_d_rem( pdig, phdl, deg4, arg4, deg2, arg2, &deg1, arg1 );

		IF_DEBUG_FLAG( DEBUG_MODUPOLY_D_POWER_REM,
		{
			cay_print( "mod %d by %d into %d to produce\n", arg4, arg2, arg1 );
			poly_z_Qmatrix_write( phdl );
		}
		);
	}

EXIT: ;

	IF_DEBUG_FLAG( DEBUG_MODUPOLY_D_POWER_REM,
	{
		cay_print( "exiting poly_u_zm_d_power_rem()" );
		cay_print( "arg1 = %d (%d),  arg2 = %d (%d),  arg3 = %d (%d),  arg4 = %d (%d)\n", arg1, deg1, arg2, deg2, arg3, deg3, arg4, deg4 );
		cay_print( "final phdl = \n" );
		poly_z_Qmatrix_write( phdl );
	}
	);
}
