#include "defs.h"
#include "globals.e"
#include "ring.e"
#include "poly.h"
#include "error.e"
#include "structure.e"
#ifndef KANT
#include "alg.e"

/*
 * Prototypes
 */

static t_handle poly_str_create_rec P_((t_handle,t_int,t_handle));

public t_handle poly_quo_str_create (pring, ideal)
t_handle pring, ideal;
{
	t_handle result;
	t_handle	cring;
	t_int		rank;
	t_pring_ptr	pringp;

	pringp = m_pring_access(pring);
	cring = m_poly_coeff_ring_ptr(pringp);
	rank =  m_poly_nvars_ptr(pringp);
	result =  poly_str_create_rec (cring, rank, NH);
	ring_incref (cring);
	/* refcount hack : we will do a hard delete when refcount == 1 */
	ring_set_is_quotient_true(result);
	ring_put_ideal(result, ideal);
	ring_put_free_ring(result, pring);
	return m_poly_str_incref (result);
}

#endif /* KANT */

public t_handle poly_str_create (cring, rank)
t_handle cring;
t_int rank;
{
	t_handle result;
	result =  poly_str_create_rec (cring, rank, NH);
	ring_incref (cring);
	/* refcount hack : we will do a hard delete when refcount == 1 */
	ring_set_is_quotient_false(result);
	return m_poly_str_incref (result);
}

private t_handle poly_str_create_rec (cring, rank, super_ring)
t_handle cring, super_ring;
t_int rank;
/*
** creates a polynomial ring over ring with the given rank.
*/
{
	t_handle		r;

	switch( ring_type( cring ))
	{
	case RING_Z:
		r = structure_alloc(sizeof( t_poly_table ),0,1,REP_POLY_Z,FALSE);
		break;

	case RING_ZM:
		r = structure_alloc(sizeof(t_poly_table ),0,1,REP_POLY_ZM,FALSE);
		break;

	case RING_GFP:
	case RING_GFQ:
#if 0
		r=structure_alloc(sizeof( t_poly_table ), 0, 1, REP_POLY_GF,FALSE);
		break;
		/* Rerouting them thru the generic polys. */
#endif

	default:
		r = structure_alloc( sizeof( t_poly_table ), 0, 1, REP_POLY, FALSE);
		break;
	}

	ring_put_type( r, RING_POLY );
	m_poly_coeff_ring( r ) = cring;
	m_poly_nvars( r ) = rank;


	if (super_ring == NH)
	{
		m_poly_first_var(r) = 1;
		super_ring = r;
	}
	else
		m_poly_first_var(r) = m_poly_nvars(super_ring) - rank + 1;

	m_poly_named_ring (r) = super_ring;

	if (rank > 1)
		m_poly_prev_ring(r) = poly_str_create_rec (cring, rank - 1, super_ring);
	else
		m_poly_prev_ring(r) = 0;

	/* AKS: make the ring ED if it is one: */

	if (ring_is_field(cring) && rank == 1)
		ring_set_is_ed_true(r);

	return r;
}
