#include "poly.h"
#include "principal_ideal.e"

t_poly
poly_reduce(qring, apoly)
t_handle	qring;
t_poly		apoly;
/*
** apoly is an element of the free ring - 
** reduce it to an elt of the quotient ring
** only works in PIDs at the moment.
*/
{
	t_poly_context	context;

	poly_init_context(qring, &context);
	return poly_reduce_crf(&context, apoly);
}

t_poly
poly_reduce_crf(context, apoly)
t_poly_ctx	context;
t_poly		apoly;
{
	t_handle	I;
	t_poly		q, r, g;

	ASSERT(m_poly_ctx_quotient(context));
	I = m_poly_ctx_ideal(context);
	ASSERT(I);
	g = m_pi_generator(I);

	/* Now divide them in the free ring and continue. */
	m_poly_ctx_quotient(context) = FALSE;
	poly_quot_rem_crf(context, apoly, g, &q, &r);
	m_poly_ctx_quotient(context) = TRUE;
	poly_elt_delete_crf(context, &q);
	return r;
}
