#include "poly.h"
#include "error.e"

t_void
poly_quot_rem (pring, apoly, bpoly, pqpoly, prpoly)
t_handle	pring;
t_poly		apoly, bpoly, *pqpoly, *prpoly;
/*
** bpoly non-zero.
** qpoly, rpoly are the unique polynomials such that 
** either bpoly | apoly, qpoly = apoly / bpoly and rpoly = 0
** or apoly = bpoly * qpoly + rpoly with deg( rpoly ) minimal.
*/
{
	t_poly_context	context;

	poly_init_context(pring, &context);
	poly_quot_rem_crf(&context, apoly, bpoly, pqpoly, prpoly);
}

t_void
poly_quot_rem_crf (context, apoly, bpoly, pqpoly, prpoly)
t_poly_ctx	context;
t_poly		apoly, bpoly, *pqpoly, *prpoly;
{
	t_poly	blead;
	t_poly	alead;
	t_int	bdeg;
	t_poly	bdashpoly;
	t_poly	q1poly;
	t_poly	qcoefft;
	t_poly	s;
	t_int	degdiff, univ;
	t_handle		q1ph;
	t_polyp			q1p, ap, bp;
	t_poly	temp;
	t_poly	temp2;
	t_poly		zeropoly;
	t_handle	zero;
	t_pfl		elt_equal;
	t_pfv		elt_delete;
	t_handle	cring;
	t_pfh		elt_slash;

	DENY ( m_poly_const( apoly ) || m_poly_const( bpoly ) );
	DENY (m_poly_ctx_quotient(context));
	elt_equal = m_poly_ctx_elt_equal(context);
	elt_delete = m_poly_ctx_elt_delete(context);
	elt_slash = m_poly_ctx_elt_slash(context);
	cring = m_poly_ctx_cring(context);

	ap = m_poly_to_ptr( apoly );
	bp = m_poly_to_ptr( bpoly );
	zeropoly = poly_zero_poly_crf(context,apoly);

#ifdef DEVELOP
	if ((m_polyp_least_pvar(ap) != m_polyp_least_pvar(bp))
	|| (m_polyp_princvar (ap)  != m_polyp_princvar (bp)))
	{
		error_internal ("poly_quot_rem: polys not lifted\n");
	}
#endif /* DEVELOP */

	bdeg = poly_deg( bpoly );
	blead = poly_lead_coefft_crf( context, bpoly );
	bdashpoly = poly_reductum_crf( context, bpoly );
	if (poly_empty(bdashpoly))
	{
		poly_elt_delete_crf(context, &bdashpoly);
		bdashpoly = 0;
	}

	*prpoly = poly_elt_incref_crf(context,apoly);
	*pqpoly = poly_zero_poly_crf(context,apoly);

	univ = m_polyp_univariate(ap);
	if (univ)
	{
		zero = ring_zero(cring);
	}
	else
	{
		zero = poly_zero_poly_crf(context, m_polyp_coefft(ap, 0));
	}
		

	while ( ! poly_eq_crf(context, zeropoly, *prpoly))
	{
		degdiff = poly_deg( *prpoly ) - bdeg;

		if ( degdiff < 0 )
		{
			/* deg( rpoly ) < deg( bpoly ) */
			/* end condition satisfied	 */

			goto EXIT;
		}

		/* continue, deg( rpoly ) >= deg( bpoly ) */

		alead = poly_lead_coefft_crf(context,*prpoly);
		if (univ)
		{
			/* 
			** I'll check that it is not zero but 
			** if it is a nonunit in Zm m composite 
			** it isn't my fault. We need the attribute/
			** type machinery to prevent this from happening.
			*/
			if ((*elt_equal)(cring, blead,0, cring,  zero, 0))
			{
				error_runtime(ERR_DIVIDE_BY_NON_UNIT, *pqpoly);
			}
				
			/* This should always work. */
			qcoefft = (*elt_slash)( cring, alead, blead);
			(*elt_delete)(cring, &alead );
		} 
		else
		{
			poly_quot_rem_crf(context, alead, blead, &qcoefft, &s );
			poly_elt_delete_crf(context, &alead );
			if ( !poly_eq_crf (context, s, zero) )
			{
				poly_elt_delete_crf( context, &qcoefft );
				poly_elt_delete_crf( context, &s );

				goto EXIT;
			}
			poly_elt_delete_crf( context, &s );
		}

		/* continue, alead == blead * qcoefft, s == 0 */

		m_poly_create_empty( &q1ph, m_polyp_princvar(ap),
					     m_polyp_least_pvar(ap), 1 );
		q1poly = m_poly_handle_to_poly( q1ph );
		q1p = m_poly_hdl_to_ptr( q1ph );

		m_polyp_coefft( q1p, 0 ) = qcoefft;
		m_polyp_expt( q1p, 0 ) = degdiff;

		/* New quotient */
		temp = *pqpoly;
		*pqpoly = poly_add_crf(context, temp, q1poly );
		poly_elt_delete_crf(context, &temp );

		/* New remainder */
		temp2 = poly_reductum_crf(context, *prpoly );
		poly_elt_delete_crf(context, prpoly );
		if (poly_empty(temp2))
		{
			poly_elt_delete_crf(context, &temp2);
			temp2 = poly_elt_incref_crf(context, zeropoly);
		}

		if (bdashpoly)
		{
			temp = poly_mult_crf(context, bdashpoly, q1poly );
			*prpoly = poly_subtract_crf( context, temp2, temp );
			poly_elt_delete_crf( context, &temp );
			poly_elt_delete_crf( context, &temp2 );
		}
		else
		{
			*prpoly = temp2;
		}
		poly_elt_delete_crf(context, &q1poly );
	}

EXIT:	;

	if (univ)
	{
		(*elt_delete)(cring, &blead);
		(*elt_delete)(cring, &zero);
	}
	else
	{
		poly_elt_delete_crf( context, &blead );
		poly_elt_delete_crf( context, &zero );
	}
	if (bdashpoly)
		poly_elt_delete_crf( context, &bdashpoly );
	if (zeropoly)
		poly_elt_delete_crf( context, &zeropoly );

	return;
}
