#include "defs.h"
#include "poly.h"

#ifndef KANT
#include "frame.e"
#include "chstr.e"
#endif

t_void
poly_elt_print(pring, apoly)
t_handle	pring;
t_poly		apoly;
{
	t_poly_context	context;
	
	poly_init_context(pring, &context);
	poly_elt_print_crf(&context, m_poly_named_ring(pring), apoly);
}





t_void	
poly_elt_print_crf(context, pring,  apoly )
t_poly_ctx 	context;
t_handle 	pring;
t_poly 		apoly;
{

	t_handle	cring;
	t_pfv		elt_print;
	t_polyp		ap;
	t_int		nterms;
	t_int		var_num;
	t_handle	var_name;
	char		*x;
	t_int		i;
	t_int		univ;
	

	DENY(m_poly_const(apoly));
	cring = m_poly_ctx_cring(context);
	elt_print = m_poly_ctx_elt_print(context);
	ap = m_poly_to_ptr(apoly);


	nterms = m_polyp_nterms( ap );
	var_num = (m_poly_nvars (pring)) - (m_polyp_princvar (ap)) + 1;

	cay_print("(");
#ifndef KANT
	var_name = frame_gen_name (pring, var_num);
	x = chstr_access (var_name);
#else
	x = "x";
#endif /* KANT */
	univ = m_polyp_univariate(ap);
	for(i = 0; i < nterms; i++)
	{
		if (univ)
		{
			(*elt_print)(cring, m_polyp_coefft(ap, i));
		}
		else
		{
			poly_elt_print_crf( context, pring, m_polyp_coefft(ap, i));
		}
		cay_print( " * %s", x);
		cay_print("^%d ", m_polyp_expt(ap, i));
		if (i < nterms - 1)
			cay_print(" + ");
	}
#ifndef KANT
        chstr_elt_delete( 0, &var_name);
#endif
	cay_print(")");
}
	
