#include "defs.h"
#include "poly.h"
#include "error.e"
#include "ring.e"
#include "structure.e"
#include "globals.e"
#ifndef KANT
#include "alg.e"
#endif

t_logical
poly_elt_coerce (polyring, str, elt, itm, nelt, nitm, do_error)
t_handle	polyring;
t_handle	str;
t_handle	elt;
t_int		itm;
t_handle 	*nelt;
t_int 		*nitm;
t_logical	do_error;
/*
** Lift elt into polyring
*/
{
	t_poly_context	context;
	t_poly_ctx	ctx;
	t_pfl		elt_coerce;
	t_handle	cring, nelth;
	t_int		it, nterms;
	t_handle	elt1;
	t_handle temp;
	t_int	i, lst_var;
	t_polyp		ap, np;
	t_logical	res;

	ASSERT (structure_repnum(polyring) == REP_POLY);
	ctx = &context;
	poly_init_context(polyring, ctx);

#ifndef KANT
	if (structure_varnum(str) != VAR_RING)
		return FALSE;
#endif

	switch (ring_type (str))
	{
	case RING_POLY :
		ap = m_poly_to_ptr(elt);
		if (m_poly_nvars(polyring) < m_poly_nvars(str))
                                error_internal ("poly_elt_coerce: can't restrict yet");
		if (m_poly_coeff_ring(str) == structure_z)
		{
			ASSERT(m_polyp_univariate(ap));
			cring = m_poly_ctx_cring(ctx);
			elt_coerce = m_poly_ctx_elt_coerce(ctx);
			nterms = m_polyp_nterms(ap);
			m_poly_create_empty(&nelth, 1,1, nterms);
			*nelt = m_poly_handle_to_poly(nelth);
			np = m_poly_hdl_to_ptr(nelth);
			for (i = 0; i < nterms; i++)
			{
				res = (*elt_coerce)(cring, structure_z, m_polyp_coefft(ap, i), 0, &temp, &it);
				ASSERT(res);
				m_polyp_coefft(np, i) = temp;
				m_polyp_expt(np, i) = m_polyp_expt(ap, i);
			}
                        if (ring_is_quotient(polyring))
                        {
                                temp = *nelt;
                                *nelt = poly_reduce(polyring, *nelt);
                                poly_elt_delete(polyring, &temp);
                        }

		}
		else
		{
			/* This is garbage once chain of rings is biffed. */
			if (m_poly_named_ring (polyring) != m_poly_named_ring (str))
				return FALSE;

			*nelt = poly_elt_incref (polyring, elt);
			lst_var = m_poly_first_var (str) + m_poly_nvars(str) - 1;
			for (i=m_poly_first_var(str) - 1;i >= m_poly_first_var(polyring); i--)
			{
				m_poly_create_empty (&temp, i, lst_var, 1);
				m_poly_coefft(temp, 0) = *nelt;
				m_poly_expt(temp, 0) = 0;
				*nelt = m_poly_handle_to_poly(temp);
			}
			if (ring_is_quotient(polyring))
			{
				temp = *nelt;
				*nelt = poly_reduce(polyring, *nelt);
				poly_elt_delete(polyring, &temp);
			}
		}
		break;
	case RING_Z:
		poly_init_context(polyring, &context);
		elt_coerce = m_poly_ctx_elt_coerce(ctx);
		cring = m_poly_context_cring(context);

		(*elt_coerce)(cring, str, elt, 0, &elt1, &it);
		lst_var = m_poly_first_var (polyring) + m_poly_nvars(polyring) - 1;
		*nelt = poly_constant_dims (polyring, m_poly_first_var(polyring), lst_var, elt1);
		break;
		
	default :
		if (m_poly_coeff_ring(polyring) != str)
			return FALSE;
		lst_var = m_poly_first_var (polyring) + m_poly_nvars(polyring) - 1;
		*nelt = poly_constant_dims (polyring, m_poly_first_var(polyring), lst_var, elt);
		break;
	}
	*nitm = 0;
	return TRUE;
}
