
#include "defs.h"
#include "bit_vector.h"
#include "dyn_arr.h"

/* 
** bit_vector package - to represent characteristic sets as found in 
** the SAC CS module.
*/

t_bit_vector 	f_bit_vector_create MEM_DECL_1(n)
t_uint	n;
{
	/* Allocate a vector with enough room for 
	** n bits. We also need a trbl header since 
	** this bit vector may be passed around a bit.
	*/
	t_bit_vector	bv;
	t_uint		x, temp;

	bv = mem_alloc_words_zero_INHERIT(bv_required_size(n));
	block_init(bv, BV_BLOCK_TYPE);
	bv_num_bits(bv) = n;
	temp = bv_num_ints(bv) = bv_bits_to_ints(n);

	for (x=0; x < temp; x++)
	{
		bv_int(bv, x) = 0;
	}
	return bv;
}

t_void	bit_vector_delete(b_vect)
t_bit_vector	*b_vect;
{
	bv_delref(*b_vect);
	*b_vect = 0;
}

t_void bit_vector_print(bv)
t_bit_vector	bv;
{
	t_uint	num_ints, num_bits;
	t_uint	j, top_bit, n;
	t_int	i;

	num_ints = bv_num_ints(bv);
	num_bits = bv_num_bits(bv);

	n = 0;
	top_bit = 1 << ((sizeof(t_uint) << 3)- 1);
	for (i = 0; i < num_ints; i++)
		for (j = 1; (1) ; j<<=1)
		{
			n++;
			if (n > num_bits) 
				break;
			if (j & bv_int(bv, i))
				cay_print("[%d : 1]", n-1);
			else
				cay_print("[%d : 0]", n-1);
			if (j == top_bit)
				break;
		} 

	dmplin();
}
	

t_bit_vector	bit_vector_AND(a, b)
t_bit_vector	a, b;
{
	t_uint	nbits;
	t_bit_vector	intersect;
	t_uint		x, temp;


	nbits = minbits(a, b);
	intersect = bit_vector_create(nbits);
	temp = bv_num_ints(intersect);

	for (x=0; x < temp; x++)
	{
		bv_int(intersect, x) = bv_int(a, x) & bv_int(b, x);
	}

	return intersect;
}

t_void bv_bit_set(bv, i)
t_bit_vector	bv;
t_int	i;
{
	t_int	intlength, intnum, bitnum;

	intlength = (sizeof(t_uint) << 3);	
	intnum = i/intlength;
	bitnum = i%intlength;

	bv_int(bv, intnum) |= (1 << bitnum);
}

t_logical bv_is_set(bv, i)
t_bit_vector	bv;
t_int	i;
{
	t_int	intlength, intnum, bitnum;

	intlength = (sizeof(t_uint) << 3);	
	intnum = i/intlength;
	bitnum = i%intlength;

	return (bv_int(bv, intnum) | (1 << bitnum));
}

#if 0
t_bit_vector	bit_vector_input(n)
t_int	n;
{
	t_int	y;
	t_bit_vector bv;

	bv = bit_vector_create(n);
	printf("\n Please input : ");
	while (1)
	{
		scanf("%d", &y); 
		if (y != 0)
		{
			bv_bit_set(bv, y-1);
		}
		else
			break;
	}
	return bv;
}
#endif

t_bit_vector	bit_vector_OR(a, b)
t_bit_vector	a, b;
{
	t_bit_vector	join_bv, temp_a, temp_b;
	t_uint		x;
	t_uint		up_bnd_bits, up_bnd_ints, low_bnd_int;

	/* Ensure that temp_a is the larger vector. */
	if (bv_num_bits(a) > bv_num_bits(b))
	{
		temp_a = a;
		temp_b = b;
	}
	else
	{
		temp_a = b;
		temp_b = a;
	}
	up_bnd_bits = bv_num_bits(temp_a);
	up_bnd_ints = bv_num_ints(temp_a);
	low_bnd_int = bv_num_ints(temp_b);

	join_bv = bit_vector_create(up_bnd_bits);

	for (x=0; x < low_bnd_int; x++)
	{
		bv_int(join_bv, x) = bv_int(temp_a, x) | bv_int(temp_b, x);
	}

	for (x=low_bnd_int; x < up_bnd_ints; x++)
	{
		bv_int(join_bv, x) = bv_int(temp_a, x);
	}

	return join_bv;
}

t_logical	bit_vector_subset(bv_a, bv_b)
t_bit_vector	bv_a, bv_b;
{
/*
** TRUE iff bv_a subset of bv_b
*/
	t_int	a_ints, b_ints, i;
	a_ints = bv_num_ints(bv_a);
	b_ints = bv_num_ints(bv_b);

	if (a_ints <= b_ints)
	{
		for (i=0; i < a_ints; i++)
			if ((bv_int(bv_a, i) & bv_int(bv_b, i))!= bv_int(bv_a, i))
				return FALSE;
	}
	else
	{
		for (i=0; i < b_ints; i++)
			if ((bv_int(bv_a, i) & bv_int(bv_b, i))!= bv_int(bv_a, i))
				return FALSE;

		for (i = b_ints; i < a_ints; i++)
			if (bv_int(bv_a, i) != 0)
				return FALSE;

	}

	return TRUE;
}
		

t_bit_vector	bit_vector_shift_left(bv, bits)
t_bit_vector	bv;
t_int		bits;
{
	t_int 		intlength, intsleft, bitsleft;
	t_int		totbits, i;
	t_bit_vector	res;
	t_uint		ovrflow, mask;

	intlength = (sizeof(t_uint) << 3);	
	intsleft = bits/intlength;
	bitsleft = bits % intlength;

	totbits = bits + bv_num_bits(bv);


	res = bit_vector_create(totbits);



	ovrflow = 0;
	mask = (((1 << (bitsleft + 1)) - 1) << (intlength - bitsleft));
	/* This is a mask of the top (bitsleft) bits. */
	for(i = 0; i < bv_num_ints(bv); i++)
	{
		bv_int(res, i + intsleft) = ((bv_int(bv, i) << bitsleft) | ovrflow);
		ovrflow = (bv_int(bv, i) & mask) >> (intlength - bitsleft);
	}

	if (ovrflow)
		bv_int(res, bv_num_ints(bv) + intsleft) = ovrflow;	
	/* If there is no overflow, then this integer hasn't even been
	** allocated. 
	*/

	return res;
}

t_logical 
bit_vector_equal WITH_2_ARGS(
t_bit_vector,	a,
t_bit_vector, 	b
)
{
	if (bit_vector_subset(a, b) && bit_vector_subset(b, a))
		return TRUE;
	return FALSE;
}
	
t_bit_vector	partition_to_set(partition)
t_handle	partition;
/* partition is a dynamic array 
** The idea is that given a 
** partition l1 + ... + lk = n
** we form the set of all integers
** which can be represented as sums of 
** subsets of l1, ...,lk
*/
{
	t_int	len;
	t_int	num, i;
	t_bit_vector	bvc, bvd, bvtemp;

	len = dyn_arr_curr_length(partition);

	bvc = bit_vector_create(1);
	bv_int(bvc, 0) = 1;
	for (i = 0; i < len; i++)
	{
		num = dyn_arr_element(partition, i);

		bvd = bit_vector_shift_left(bvc, num);

		bvtemp = bit_vector_OR(bvc, bvd);

		bit_vector_delete(&bvc);
		bit_vector_delete(&bvd);
		bvc = bvtemp;
	}
	return bvc;
}

